# Rate Limits

API v2 uses rate limiting to prevent abuse. Rate limits are configured per domain, and all endpoints within the same domain share the same rate limit.

## Rate Limits by Domain

| Domain | Rate Limit (requests per minute) |
|--------|-----------------------------------|
| Customer Information | 480 |
| Charts & Metrics | 5 |
| Project Configuration | 60 |
| Virtual Currencies - Create Transaction | 480 |

Each endpoint belongs to one of these domains. The rate limit applies per API key (for app-level keys) or per developer (for developer-level keys).

## Rate Limit Headers

We will return the following headers on all successful requests:

* `RevenueCat-Rate-Limit-Current-Usage`: the number of executed requests for the current rate limiting period, including the current request. The rate limiting period is one minute.
* `RevenueCat-Rate-Limit-Current-Limit`: the limit in requests per minute for this endpoint

If you reach the rate limit, as indicated by a 429 error code, we will also include the following header:

* `Retry-After`: the number of seconds to wait until you can retry this request.

Below is an example of the response body that will be sent when the rate limit is reached. The value of the `backoff_ms` field corresponds to the `Retry-After`` header but specified in milliseconds.

```
{
  "type": "rate_limit_error",
  "message": "Rate limit exceeded",
  "retryable": true,
  "doc_url": "https://errors.rev.cat/rate-limit-error",
  "backoff_ms": 1000
}
```
