# Purchase

Operations about purchases.

## Endpoints

### GET /projects/{project_id}/purchases

Search one-time purchases by store purchase identifier

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** store_purchase_identifier (query, required) — Store ID associated with the one-time purchase.
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's purchases. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/purchases?starting_after=purc1a2b3c4d5e")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/purchases")
- **Status:** public

### GET /projects/{project_id}/purchases/{purchase_id}

Get a purchase

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), purchase_id (path, required) — ID of the purchase (e.g., "purc1a2b3c4d5e")
- **Response:**
  - object: enum: purchase (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the purchase (e.g., "purch1a2b3c4d5e")
  - customer_id: string (required) — The id of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - original_customer_id: string (required) — The ID of the original customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - product_id: string (required) — The ID of the product that was purchased (e.g., "prod1a2b3c4d5e")
  - purchased_at: integer(int64) (required) — The date when the purchase was made in ms since epoch (e.g., 1658399423658)
  - revenue_in_usd: object (required) — The revenue generated by the purchase in USD
  - quantity: integer (required) — The quantity of the product purchased in one transaction (e.g., 1)
  - status: enum: owned, refunded (required) — The status of a purchase (e.g., "owned")
  - presented_offering_id: string, nullable (required) — The ID of the offering the customer saw when they did the purchase (e.g., "ofrnge1a2b3c4d5")
  - entitlements: object (required)
  - environment: enum: production, sandbox (required) — The store environment (e.g., "production")
  - store: enum: amazon, app_store, mac_app_store, play_store, promotional, stripe, rc_billing (required) — Store the purchase belongs to (e.g., "amazon")
  - store_purchase_identifier: string (required) — The store purchase identifier (e.g., 12345678)
  - ownership: enum: purchased, family_shared (required) — Ownership of the purchase
  - country: enum: , AF, AL, DZ, AS, AD, AO, AI, AQ, AG, ... (250 total), nullable — Billing country in ISO alpha 2 code (e.g., "US")
- **Status:** public

### POST /projects/{project_id}/purchases/{purchase_id}/actions/refund

Refund a Web Billing purchase

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), purchase_id (path, required) — ID of the purchase (e.g., "purc1a2b3c4d5e")
- **Response:**
  - object: enum: purchase (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the purchase (e.g., "purch1a2b3c4d5e")
  - customer_id: string (required) — The id of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - original_customer_id: string (required) — The ID of the original customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - product_id: string (required) — The ID of the product that was purchased (e.g., "prod1a2b3c4d5e")
  - purchased_at: integer(int64) (required) — The date when the purchase was made in ms since epoch (e.g., 1658399423658)
  - revenue_in_usd: object (required) — The revenue generated by the purchase in USD
  - quantity: integer (required) — The quantity of the product purchased in one transaction (e.g., 1)
  - status: enum: owned, refunded (required) — The status of a purchase (e.g., "owned")
  - presented_offering_id: string, nullable (required) — The ID of the offering the customer saw when they did the purchase (e.g., "ofrnge1a2b3c4d5")
  - entitlements: object (required)
  - environment: enum: production, sandbox (required) — The store environment (e.g., "production")
  - store: enum: amazon, app_store, mac_app_store, play_store, promotional, stripe, rc_billing (required) — Store the purchase belongs to (e.g., "amazon")
  - store_purchase_identifier: string (required) — The store purchase identifier (e.g., 12345678)
  - ownership: enum: purchased, family_shared (required) — Ownership of the purchase
  - country: enum: , AF, AL, DZ, AS, AD, AO, AI, AQ, AG, ... (250 total), nullable — Billing country in ISO alpha 2 code (e.g., "US")
- **Status:** public

### GET /projects/{project_id}/purchases/{purchase_id}/entitlements

Get a list of entitlements associated with a purchase

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), purchase_id (path, required) — ID of the purchase (e.g., "purc1a2b3c4d5e")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's entitlements. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/entitlements?starting_after=entlab21dac")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/entitlements")
- **Status:** public
