# App

Operations about apps.

## Endpoints

### GET /projects/{project_id}/apps

Get a list of apps

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's apps. If not present / null, there is no next page (e.g., "/v2/projects/projec1a2b3c4d/apps?starting_after=app1a2b3c4d")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/projec1a2b3c4d/apps")
- **Status:** public

### POST /projects/{project_id}/apps

Create an App

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Body:**
  - name: string (required) — The name of the app
  - type: enum: amazon, app_store, mac_app_store, play_store, stripe, rc_billing, roku, paddle (required) — The platform of the app.
  - Mac App Store is disabled by default. See [Legacy Mac Apps](https://www.revenuecat.com/docs/legacy-mac-apps) for more details.
  - amazon: object — Amazon type details. Should only be used when type is amazon.
    - package_name: string (required) — The package name of the app
    - shared_secret: string — Your Amazon Developer Identity Shared Key
  - app_store: object — App Store type details. Should only be used when type is app_store.
    - bundle_id: string (required) — The bundle ID of the app
    - shared_secret: string — The shared secret of the app
    - subscription_private_key: string — PKCS /#8 In App Key downloaded from App Store Connect in PEM format. Copy the contents
    - of the file in this field. See instructions on how to get it in:
    - https://www.revenuecat.com/docs/in-app-purchase-key-configuration
    - subscription_key_id: string — In App Key id. The ID of the downloaded in app key. You can get it from App Store Connect
    - subscription_key_issuer: string — The key Issuer id. See instructions on how to obtain this in: https://www.revenuecat.com/docs/in-app-purchase-key-configuration#3-providing-the-issuer-id-to-revenuecat
    - app_store_connect_api_key: string — App Store Connect API Key downloaded from App Store Connect in PEM format. Copy the contents
    - of the file in this field. This is optional and used for advanced features like product imports.
    - app_store_connect_api_key_id: string — App Store Connect API Key ID. The ID of the downloaded API key. You can get it from App Store Connect.
    - app_store_connect_api_key_issuer: string — App Store Connect API Key Issuer ID.
    - app_store_connect_vendor_number: string — Your vendor number from App Store Connect. Required for some features like financial reports.
  - mac_app_store: object — Mac App Store type details. Should only be used when type is mac_app_store.
    - bundle_id: string (required) — The bundle ID of the app
    - shared_secret: string — The shared secret of the app
  - play_store: object — Play Store type details. Should only be used when type is play_store.
    - package_name: string (required) — The package name of the app
  - stripe: object — Stripe type details. Should only be used when type is stripe.
    - stripe_account_id: string, nullable — It needs to be connected to your RevenueCat account. It can be omitted if you only have a single Stripe account connected to your RevenueCat account.
  - rc_billing: object, nullable — Revenue Cat Billing Store type details
    - stripe_account_id: string, nullable — It needs to be connected to your RevenueCat account. It can be omitted if you only have a single Stripe account connected to your RevenueCat account.
    - app_name: string (required) — Shown in checkout, emails, and receipts sent to customers.
    - support_email: string, nullable — Used as the `reply to` address in all emails sent to customers, to allow them to receive support. If you leave this field blank, your RevenueCat account email address will be used.
    - default_currency: enum: USD, EUR, JPY, GBP, AUD, CAD, BRL, KRW, CNY, MXN, ... (46 total) — ISO 4217 currency code (e.g., "USD")
  - roku: object, nullable — Roku Channel Store details. Should only be used when type is roku.
    - roku_api_key: string, nullable — Roku Pay API key provided on the Roku Pay Web Services page.
    - roku_channel_id: string, nullable — Channel ID provided on the Roku Channel page.
    - roku_channel_name: string, nullable — Channel name that is displayed on the Roku Channel page.
  - paddle: object, nullable — Paddle Billing details. Should only be used when type is paddle.
    - paddle_api_key: string, nullable — Paddle Server-side API key provided on the Paddle dashboard.
    - paddle_is_sandbox: boolean, nullable — [Deprecated] Whether the app is tied to the sandbox environment. (e.g., true)
    - This field is deprecated and will be removed in the future.
    - The environment is determined by the `paddle_api_key` format.
- **Response:**
  - object: enum: app (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the app (e.g., "app1a2b3c4")
  - name: string (required) — The name of the app
  - created_at: integer(int64) (required) — The date when the app was created in ms since epoch (e.g., 1658399423658)
  - type: enum: amazon, app_store, mac_app_store, play_store, stripe, rc_billing, roku, paddle, test_store (required) — The platform of the app (e.g., "app_store")
  - project_id: string (required) — The id of the project (e.g., "proj1a2b3c4")
  - amazon: object — Amazon type details
  - app_store: object — App Store type details
  - mac_app_store: object — Legacy Mac App Store type details
  - play_store: object — Play Store type details
  - stripe: object — Stripe type details
  - rc_billing: object — Revenue Cat Billing Store type details
  - roku: object — Roku Channel Store type details
  - paddle: object — Paddle Billing type details
- **Status:** public

### DELETE /projects/{project_id}/apps/{app_id}

Delete an app

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), app_id (path, required) — ID of the app (e.g., "app1ab2c3d4")
- **Response:**
  - object: enum: app, customer, entitlement, offering, package, product, virtual_currency, webhook_integration (required) — The type of the deleted object
  - id: string (required) — The ID of the deleted object
  - deleted_at: integer(int64) (required) — The date when the object was deleted in ms since epoch (e.g., 1658399423658)
- **Status:** public

### GET /projects/{project_id}/apps/{app_id}

Get an app

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), app_id (path, required) — ID of the app (e.g., "app1ab2c3d4")
- **Response:**
  - object: enum: app (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the app (e.g., "app1a2b3c4")
  - name: string (required) — The name of the app
  - created_at: integer(int64) (required) — The date when the app was created in ms since epoch (e.g., 1658399423658)
  - type: enum: amazon, app_store, mac_app_store, play_store, stripe, rc_billing, roku, paddle, test_store (required) — The platform of the app (e.g., "app_store")
  - project_id: string (required) — The id of the project (e.g., "proj1a2b3c4")
  - amazon: object — Amazon type details
  - app_store: object — App Store type details
  - mac_app_store: object — Legacy Mac App Store type details
  - play_store: object — Play Store type details
  - stripe: object — Stripe type details
  - rc_billing: object — Revenue Cat Billing Store type details
  - roku: object — Roku Channel Store type details
  - paddle: object — Paddle Billing type details
- **Status:** public

### POST /projects/{project_id}/apps/{app_id}

Update an app

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), app_id (path, required) — ID of the app (e.g., "app1ab2c3d4")
- **Body:**
  - name: string — The name of the app (e.g., "My App")
  - amazon: object — Amazon type details. Should only be used when type is amazon.
    - package_name: string — The package name of the app
    - shared_secret: string, nullable — Your Amazon Developer Identity Shared Key
  - app_store: object — App Store type details. Should only be used when type is app_store.
    - bundle_id: string — The bundle ID of the app
    - shared_secret: string, nullable — The shared secret of the app
    - subscription_private_key: string — PKCS
    - subscription_key_id: string — In App Key id. The ID of the downloaded in app key. You can get it from App Store Connect
    - subscription_key_issuer: string — The key Issuer id. See instructions on how to obtain this in https://www.revenuecat.com/docs/in-app-purchase-key-configuration#3-providing-the-issuer-id-to-revenuecat
    - app_store_connect_api_key: string — App Store Connect API Key downloaded from App Store Connect in PEM format. Copy the contents of the file in this field. This is optional and used for advanced features like product imports.
    - app_store_connect_api_key_id: string — App Store Connect API Key ID. The ID of the downloaded API key. You can get it from App Store Connect.
    - app_store_connect_api_key_issuer: string — App Store Connect API Key Issuer ID.
    - app_store_connect_vendor_number: string — Your vendor number from App Store Connect. Required for some features like financial reports.
  - mac_app_store: object — Legacy Mac App Store type details. Should only be used when type is mac_app_store.
    - bundle_id: string — The bundle ID of the app
    - shared_secret: string, nullable — The shared secret of the app
  - play_store: object — Play Store type details. Should only be used when type is play_store.
    - package_name: string (required) — The package name of the app
  - stripe: object — Stripe type details. Should only be used when type is stripe.
    - stripe_account_id: string — It needs to be connected to your RevenueCat account. It can be omitted if you only have a single Stripe account connected to your RevenueCat account.
  - rc_billing: object — Web Billing type details. Should only be used when type is rc_billing.
    - stripe_account_id: string, nullable — It needs to be connected to your RevenueCat account. It can be omitted if you only have a single Stripe account connected to your RevenueCat account.
    - app_name: string, nullable — Shown in checkout, emails, and receipts sent to customers.
    - support_email: string, nullable — Used as the `reply to` address in all emails sent to customers, to allow them to receive support. If you leave this field blank, your RevenueCat account email address will be used.
    - default_currency: enum: USD, EUR, JPY, GBP, AUD, CAD, BRL, KRW, CNY, MXN, ... (46 total) — ISO 4217 currency code (e.g., "USD")
  - roku: object — Roku Channel Store type details. Should only be used when type is roku.
    - roku_api_key: string, nullable — Roku Pay API key provided on the Roku Pay Web Services page.
    - roku_channel_id: string, nullable — Channel ID provided on the Roku Channel page.
    - roku_channel_name: string, nullable — Channel name that is displayed on the Roku Channel page.
  - paddle: object — Paddle Billing type details. Should only be used when type is paddle.
    - paddle_api_key: string, nullable — Paddle Server-side API key provided on the Paddle dashboard.
    - paddle_is_sandbox: boolean — Whether the app is tied to the sandbox environment. (e.g., true)
- **Response:**
  - object: enum: app (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the app (e.g., "app1a2b3c4")
  - name: string (required) — The name of the app
  - created_at: integer(int64) (required) — The date when the app was created in ms since epoch (e.g., 1658399423658)
  - type: enum: amazon, app_store, mac_app_store, play_store, stripe, rc_billing, roku, paddle, test_store (required) — The platform of the app (e.g., "app_store")
  - project_id: string (required) — The id of the project (e.g., "proj1a2b3c4")
  - amazon: object — Amazon type details
  - app_store: object — App Store type details
  - mac_app_store: object — Legacy Mac App Store type details
  - play_store: object — Play Store type details
  - stripe: object — Stripe type details
  - rc_billing: object — Revenue Cat Billing Store type details
  - roku: object — Roku Channel Store type details
  - paddle: object — Paddle Billing type details
- **Status:** public

### GET /projects/{project_id}/apps/{app_id}/public_api_keys

Get a list of the public API keys of an app

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), app_id (path, required) — ID of the app (e.g., "app1ab2c3d4")
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the app's public API keys. If not present / null, there is no next page (e.g., "/v2/projects/projec1a2b3c4d/apps/app1a2b3c4d/public_api_keys?starting_after=pub1a2b3c4d")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/projec1a2b3c4d/apps/app1a2b3c4d/public_api_keys")
- **Status:** public

### GET /projects/{project_id}/apps/{app_id}/store_kit_config

Get the StoreKit configuration for an app

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), app_id (path, required) — ID of the app (e.g., "app1ab2c3d4")
- **Response:**
  - object: enum: store_kit_config_file (required) — String representing the object's type. Objects of the same type share the same value.
  - contents: object (required) — Contents of the StoreKit config file
- **Status:** public

# Collaborator

Operations about collaborators.

## Endpoints

### GET /projects/{project_id}/collaborators

Get a list of collaborators

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's collaborators. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/collaborators?starting_after=collab1a2b3c4d5")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/collaborators")
- **Status:** public

# Project

Operations about projects.

## Endpoints

### GET /projects

Get a list of projects

- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the projects. If not present / null, there is no next page (e.g., "/v2/projects?starting_after=projab21dac")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects")
- **Status:** public

### POST /projects

Creates a new project

- **Body:**
  - name: string (required) — The name of the project
- **Response:**
  - object: enum: project (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the project (e.g., "proj1ab2c3d4")
  - name: string (required) — The name of the project (e.g., "MagicWeather")
  - created_at: integer(int64) (required) — The date when the project was created in ms since epoch (e.g., 1658399423658)
  - icon_url: string, nullable — The URL of the project's icon (small size) (e.g., "https://www.appatar.io/abc123/small")
  - icon_url_large: string, nullable — The URL of the project's icon (large size) (e.g., "https://www.appatar.io/abc123/large")
- **Status:** public
