# Product

Operations about products.

## Endpoints

### GET /projects/{project_id}/products

Get a list of products

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** app_id (query, optional) — This is an optional query parameter to get a list of products of a given entitlement associated with a particular app (e.g., "app1a2b3c4"), starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10), expand (query, optional) — Specifies which fields in the response should be expanded. Accepted values are: `items.app` (requires `project_configuration:apps:read` permission).
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's products. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/products?starting_after=prodab21dac")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/products")
- **Status:** public

### POST /projects/{project_id}/products

Create a product

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Body:**
  - store_identifier: string (required) — The store identifier of the product. (e.g., "com.revenuecat.magicweather.monthly")
  - For Apple App Store products this is the product ID of the subscription or in-app product.
  - For Google's Play Store, it should follow the format 'productId:basePlanId' for subscription products and SKU for one-time purchase products.
  - For Stripe, the product identifier that always starts with "prod_"
  - For Amazon, if it's a subscription, the term SKU of the subscription. If it's a one-time purchase, the SKU of the product.
  - For Roku, this is the product identifier of the subscription or one-time purchase product.
  - app_id: string (required) — The ID of the app (e.g., "app1a2b3c4")
  - type: enum: subscription, one_time, consumable, non_consumable, non_renewing_subscription (required) — The product type
  - display_name: string, nullable — The display name of the product (e.g., "Premium Monthly 2023")
  - subscription: object, nullable — Subscription parameters. Only supported for test store products.
    - duration: enum: P1W, P1M, P2M, P3M, P6M, P1Y (required) — The duration of the subscription. Only supported for test store products. (e.g., "P1W")
  - title: string, nullable — The user-facing title of the product. This field is required for Test Store products. (e.g., "Premium Monthly 2023")
- **Response:**
  - object: enum: product (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - id: string (required) — The id of the product (e.g., "prod1a2b3c4d5e")
  - store_identifier: string (required) — The store product identifier (e.g., "rc_1w_199")
  - type: enum: subscription, one_time, consumable, non_consumable, non_renewing_subscription (required) — The product type
  - subscription: object, nullable — The subscription product object
  - one_time: object, nullable — The one time product object
  - created_at: integer(int64) (required) — The date when the product was created in ms since epoch (e.g., 1658399423658)
  - app_id: string (required) — The id of the app (e.g., "app1a2b3c4")
  - app: object, nullable — The app associated with the product
  - display_name: string, nullable (required) — The display name of the product (e.g., "Premium Monthly 2023")
- **Status:** public

### DELETE /projects/{project_id}/products/{product_id}

Delete a product

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), product_id (path, required) — ID of the product (e.g., "prod1a2b3c4d5")
- **Response:**
  - object: enum: app, customer, entitlement, offering, package, paywall, product, virtual_currency, webhook_integration (required) — The type of the deleted object
  - id: string (required) — The ID of the deleted object
  - deleted_at: integer(int64) (required) — The date when the object was deleted in ms since epoch (e.g., 1658399423658)
- **Status:** public

### GET /projects/{project_id}/products/{product_id}

Get a product

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), product_id (path, required) — ID of the product (e.g., "prod1a2b3c4d5")
- **Query:** expand (query, optional) — Specifies which fields in the response should be expanded. Accepted values are: `app` (requires `project_configuration:apps:read` permission).
- **Response:**
  - object: enum: product (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - id: string (required) — The id of the product (e.g., "prod1a2b3c4d5e")
  - store_identifier: string (required) — The store product identifier (e.g., "rc_1w_199")
  - type: enum: subscription, one_time, consumable, non_consumable, non_renewing_subscription (required) — The product type
  - subscription: object, nullable — The subscription product object
  - one_time: object, nullable — The one time product object
  - created_at: integer(int64) (required) — The date when the product was created in ms since epoch (e.g., 1658399423658)
  - app_id: string (required) — The id of the app (e.g., "app1a2b3c4")
  - app: object, nullable — The app associated with the product
  - display_name: string, nullable (required) — The display name of the product (e.g., "Premium Monthly 2023")
- **Status:** public

### POST /projects/{project_id}/products/{product_id}/create_in_store

Push a product to the store

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), product_id (path, required) — ID of the product (e.g., "prod1a2b3c4d5")
- **Body:**
  - store_information: object — Store-specific information for creating the product in the store
    - duration: enum: ONE_WEEK, ONE_MONTH, TWO_MONTHS, THREE_MONTHS, SIX_MONTHS, ONE_YEAR (required) — The subscription duration period
    - subscription_group_name: string (required) — The name of the subscription group
    - subscription_group_id: string, nullable — The ID of the subscription group (optional)
- **Response:**
  - created_product: object (required)
- **Status:** public
