# Offering

Operations about offerings.

## Endpoints

### GET /projects/{project_id}/offerings

Get a list of offerings

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10), expand (query, optional) — Specifies which fields in the response should be expanded. Accepted values are: `items.package` (requires `project_configuration:packages:read` permission), `items.package.product` (requires `project_configuration:products:read` permission).
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's offerings. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/offerings?starting_after=ofrngeab21da")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/offerings")
- **Status:** public

### POST /projects/{project_id}/offerings

Create an offering

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Body:**
  - lookup_key: string (required) — The custom identifier of the offering (e.g., "default")
  - display_name: string (required) — The display_name of the offering (e.g., "The standard set of packages")
  - metadata: object, nullable — Custom metadata of the offering (e.g., {"color":"blue","call_to_action":"Subscribe Now!"})
- **Response:**
  - object: enum: offering (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the offering (e.g., "ofrnge1a2b3c4d5")
  - lookup_key: string (required) — A custom identifier of the entitlement (e.g., "default")
  - display_name: string (required) — The display name of the offering (e.g., "The standard set of packages")
  - is_current: boolean (required) — Indicates if the offering is the current offering (e.g., true)
  - created_at: integer(int64) (required) — The date the offering was created at in ms since epoch (e.g., 1658399423658)
  - project_id: string (required) — ID of the project to which the offering belongs (e.g., "proj1ab2c3d4")
  - metadata: object, nullable — Custom metadata of the offering (e.g., {"color":"blue","call_to_action":"Subscribe Now!"})
  - packages: object, nullable
- **Status:** public

### DELETE /projects/{project_id}/offerings/{offering_id}

Delete an offering and its attached packages

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), offering_id (path, required) — ID of the offering (e.g., "ofrnge1a2b3c4d5")
- **Response:**
  - object: enum: app, customer, entitlement, offering, package, paywall, product, virtual_currency, webhook_integration (required) — The type of the deleted object
  - id: string (required) — The ID of the deleted object
  - deleted_at: integer(int64) (required) — The date when the object was deleted in ms since epoch (e.g., 1658399423658)
- **Status:** public

### GET /projects/{project_id}/offerings/{offering_id}

Get an offering

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), offering_id (path, required) — ID of the offering (e.g., "ofrnge1a2b3c4d5")
- **Query:** expand (query, optional) — Specifies which fields in the response should be expanded. Accepted values are: `package` (requires `project_configuration:packages:read` permission), `package.product` (requires `project_configuration:products:read` permission).
- **Response:**
  - object: enum: offering (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the offering (e.g., "ofrnge1a2b3c4d5")
  - lookup_key: string (required) — A custom identifier of the entitlement (e.g., "default")
  - display_name: string (required) — The display name of the offering (e.g., "The standard set of packages")
  - is_current: boolean (required) — Indicates if the offering is the current offering (e.g., true)
  - created_at: integer(int64) (required) — The date the offering was created at in ms since epoch (e.g., 1658399423658)
  - project_id: string (required) — ID of the project to which the offering belongs (e.g., "proj1ab2c3d4")
  - metadata: object, nullable — Custom metadata of the offering (e.g., {"color":"blue","call_to_action":"Subscribe Now!"})
  - packages: object, nullable
- **Status:** public

### POST /projects/{project_id}/offerings/{offering_id}

Update an offering

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), offering_id (path, required) — ID of the offering (e.g., "ofrnge1a2b3c4d5")
- **Body:**
  - display_name: string — The display name of the offering (e.g., "premium access to features")
  - is_current: boolean — Indicates if the offering is the current offering (e.g., true)
  - metadata: object, nullable — Custom metadata of the offering (e.g., {"color":"blue","call_to_action":"Subscribe Now!"})
- **Response:**
  - object: enum: offering (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the offering (e.g., "ofrnge1a2b3c4d5")
  - lookup_key: string (required) — A custom identifier of the entitlement (e.g., "default")
  - display_name: string (required) — The display name of the offering (e.g., "The standard set of packages")
  - is_current: boolean (required) — Indicates if the offering is the current offering (e.g., true)
  - created_at: integer(int64) (required) — The date the offering was created at in ms since epoch (e.g., 1658399423658)
  - project_id: string (required) — ID of the project to which the offering belongs (e.g., "proj1ab2c3d4")
  - metadata: object, nullable — Custom metadata of the offering (e.g., {"color":"blue","call_to_action":"Subscribe Now!"})
  - packages: object, nullable
- **Status:** public

# Package

Operations about packages.

## Endpoints

### GET /projects/{project_id}/offerings/{offering_id}/packages

Get a list of packages in an offering

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), offering_id (path, required) — ID of the offering (e.g., "ofrnge1a2b3c4d5")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10), expand (query, optional) — Specifies which fields in the response should be expanded. Accepted values are: `items.product` (requires `project_configuration:products:read` permission).
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's packages. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/offerings/ofrnge1a2b3c4d5/packages?starting_after=pkgeab21dac")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/offerings/ofrnge1a2b3c4d5/packages")
- **Status:** public

### POST /projects/{project_id}/offerings/{offering_id}/packages

Create a package

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), offering_id (path, required) — ID of the offering (e.g., "ofrnge1a2b3c4d5")
- **Body:**
  - lookup_key: string (required) — The lookup_key of the package (e.g., "monthly")
  - display_name: string (required) — The display name of the package (e.g., "monthly with one-week trial")
  - position: integer — The position of the package in the offering (e.g., 1)
- **Response:**
  - object: enum: package (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the package (e.g., "pkge1a2b3c4d5")
  - lookup_key: string (required) — The lookup_key of the package (e.g., "monthly")
  - display_name: string (required) — The display name of the package (e.g., "Monthly discounted with 3-day trial")
  - position: integer, nullable (required) — The position of the package within the offering (e.g., 1)
  - created_at: integer(int64) (required) — The date the package was created at in ms since epoch (e.g., 1658399423658)
  - products: object, nullable
- **Status:** public

### DELETE /projects/{project_id}/packages/{package_id}

Delete a package

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), package_id (path, required) — ID of the package (e.g., "pkge1a2b3c4d5")
- **Response:**
  - object: enum: app, customer, entitlement, offering, package, paywall, product, virtual_currency, webhook_integration (required) — The type of the deleted object
  - id: string (required) — The ID of the deleted object
  - deleted_at: integer(int64) (required) — The date when the object was deleted in ms since epoch (e.g., 1658399423658)
- **Status:** public

### GET /projects/{project_id}/packages/{package_id}

Get a package

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), package_id (path, required) — ID of the package (e.g., "pkge1a2b3c4d5")
- **Query:** expand (query, optional) — Specifies which fields in the response should be expanded. Accepted values are: `product` (requires `project_configuration:products:read` permission).
- **Response:**
  - object: enum: package (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the package (e.g., "pkge1a2b3c4d5")
  - lookup_key: string (required) — The lookup_key of the package (e.g., "monthly")
  - display_name: string (required) — The display name of the package (e.g., "Monthly discounted with 3-day trial")
  - position: integer, nullable (required) — The position of the package within the offering (e.g., 1)
  - created_at: integer(int64) (required) — The date the package was created at in ms since epoch (e.g., 1658399423658)
  - products: object, nullable
- **Status:** public

### POST /projects/{project_id}/packages/{package_id}

Update a package

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), package_id (path, required) — ID of the package (e.g., "pkge1a2b3c4d5")
- **Body:**
  - display_name: string — The display name of the package (e.g., "monthly with one-week trial")
  - position: integer — The position of the package within the offering (e.g., 2)
- **Response:**
  - object: enum: package (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the package (e.g., "pkge1a2b3c4d5")
  - lookup_key: string (required) — The lookup_key of the package (e.g., "monthly")
  - display_name: string (required) — The display name of the package (e.g., "Monthly discounted with 3-day trial")
  - position: integer, nullable (required) — The position of the package within the offering (e.g., 1)
  - created_at: integer(int64) (required) — The date the package was created at in ms since epoch (e.g., 1658399423658)
  - products: object, nullable
- **Status:** public

### POST /projects/{project_id}/packages/{package_id}/actions/attach_products

Attach a set of products to a package

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), package_id (path, required) — ID of the package (e.g., "pkge1a2b3c4d5")
- **Body:**
  - products: array (required) — Product association list
- **Response:**
  - object: enum: package (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the package (e.g., "pkge1a2b3c4d5")
  - lookup_key: string (required) — The lookup_key of the package (e.g., "monthly")
  - display_name: string (required) — The display name of the package (e.g., "Monthly discounted with 3-day trial")
  - position: integer, nullable (required) — The position of the package within the offering (e.g., 1)
  - created_at: integer(int64) (required) — The date the package was created at in ms since epoch (e.g., 1658399423658)
  - products: object, nullable
- **Status:** public

### POST /projects/{project_id}/packages/{package_id}/actions/detach_products

Detach a set of products from a package

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), package_id (path, required) — ID of the package (e.g., "pkge1a2b3c4d5")
- **Body:**
  - product_ids: array (required) — IDs of the products to detach from the package
- **Response:**
  - object: enum: package (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) — The id of the package (e.g., "pkge1a2b3c4d5")
  - lookup_key: string (required) — The lookup_key of the package (e.g., "monthly")
  - display_name: string (required) — The display name of the package (e.g., "Monthly discounted with 3-day trial")
  - position: integer, nullable (required) — The position of the package within the offering (e.g., 1)
  - created_at: integer(int64) (required) — The date the package was created at in ms since epoch (e.g., 1658399423658)
  - products: object, nullable
- **Status:** public

### GET /projects/{project_id}/packages/{package_id}/products

Get a list of products attached to a given package of an offering

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), package_id (path, required) — ID of the package (e.g., "pkge1a2b3c4d5")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the entitlement's products. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/packages/pkge1a2b3c4d5/products?starting_after=prod1a2b3c4d5")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/packages/pkge1a2b3c4d5/products")
- **Status:** public
