# Integration

Operations about integrations.

## Endpoints

### GET /projects/{project_id}/integrations/webhooks

List webhook integrations

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the
  - same value.
  - items: array (required) — Webhook integrations configured for the project.
  - next_page: string, nullable — URL to access the next page of webhook integrations. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/integrations/webhooks?starting_after=whintgr1a2b3c4d")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/integrations/webhooks")
- **Status:** public

### POST /projects/{project_id}/integrations/webhooks

Create a webhook integration

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Body:**
  - name: string (required) — The display name of the webhook integration (e.g., "Customer updates webhook")
  - url: string (required) — The URL RevenueCat will send webhook notifications to (e.g., "https://hooks.example.com/revenuecat")
  - authorization_header: string, nullable — Optional authorization header that will be sent with webhook notifications (e.g., "Bearer 123456")
  - environment: enum: production, sandbox, , nullable — The environment the webhook integration is configured for
  - event_types: array, nullable — Event types that will trigger the webhook
  - app_id: string, nullable — The ID of the app the webhook integration is scoped to (e.g., "app_1234567890abcdef")
- **Response:**
  - object: enum: webhook_integration (required) — String representing the object's type. Objects of the same type share the
  - same value.
  - id: string (required) — The ID of the webhook integration (e.g., "wh_1234567890abcdef")
  - project_id: string (required) — The ID of the project the webhook integration belongs to (e.g., "proj_1234567890abcdef")
  - name: string (required) — The display name of the webhook integration (e.g., "Customer updates webhook")
  - url: string (required) — The URL RevenueCat will send webhook notifications to (e.g., "https://hooks.example.com/revenuecat")
  - environment: enum: production, sandbox, , nullable (required) — The environment the webhook integration is configured for. Only events for the selected environment will be sent.
  - event_types: array, nullable — Event types that will trigger the webhook. Only events for the selected event types will be sent.
  - app_id: string, nullable (required) — The ID of the app the webhook integration is scoped to. If not provided, the webhook integration will be scoped to all apps in the project. (e.g., "app_1234567890abcdef")
  - created_at: integer(int64) (required) — The timestamp in ms since epoch when the webhook integration was created (e.g., 1658399423658)
- **Status:** public

### DELETE /projects/{project_id}/integrations/webhooks/{webhook_integration_id}

Delete a webhook integration

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), webhook_integration_id (path, required) — The ID of the webhook integration (e.g., "wh_1234567890abcdef")
- **Response:**
  - object: enum: app, customer, entitlement, offering, package, paywall, product, virtual_currency, webhook_integration (required) — The type of the deleted object
  - id: string (required) — The ID of the deleted object
  - deleted_at: integer(int64) (required) — The date when the object was deleted in ms since epoch (e.g., 1658399423658)
- **Status:** public

### GET /projects/{project_id}/integrations/webhooks/{webhook_integration_id}

Get a webhook integration

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), webhook_integration_id (path, required) — The ID of the webhook integration (e.g., "wh_1234567890abcdef")
- **Response:**
  - object: enum: webhook_integration (required) — String representing the object's type. Objects of the same type share the
  - same value.
  - id: string (required) — The ID of the webhook integration (e.g., "wh_1234567890abcdef")
  - project_id: string (required) — The ID of the project the webhook integration belongs to (e.g., "proj_1234567890abcdef")
  - name: string (required) — The display name of the webhook integration (e.g., "Customer updates webhook")
  - url: string (required) — The URL RevenueCat will send webhook notifications to (e.g., "https://hooks.example.com/revenuecat")
  - environment: enum: production, sandbox, , nullable (required) — The environment the webhook integration is configured for. Only events for the selected environment will be sent.
  - event_types: array, nullable — Event types that will trigger the webhook. Only events for the selected event types will be sent.
  - app_id: string, nullable (required) — The ID of the app the webhook integration is scoped to. If not provided, the webhook integration will be scoped to all apps in the project. (e.g., "app_1234567890abcdef")
  - created_at: integer(int64) (required) — The timestamp in ms since epoch when the webhook integration was created (e.g., 1658399423658)
- **Status:** public

### POST /projects/{project_id}/integrations/webhooks/{webhook_integration_id}

Update a webhook integration

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), webhook_integration_id (path, required) — The ID of the webhook integration (e.g., "wh_1234567890abcdef")
- **Body:**
  - name: string — The display name of the webhook integration (e.g., "Customer updates webhook")
  - url: string — The URL RevenueCat will send webhook notifications to (e.g., "https://hooks.example.com/revenuecat")
  - authorization_header: string, nullable — Optional authorization header that will be sent with webhook notifications (e.g., "Bearer 123456")
  - environment: enum: production, sandbox, , nullable — The environment the webhook integration is configured for
  - event_types: array, nullable — Event types that will trigger the webhook
  - app_id: string, nullable — The ID of the app the webhook integration is scoped to (e.g., "app_1234567890abcdef")
- **Response:**
  - object: enum: webhook_integration (required) — String representing the object's type. Objects of the same type share the
  - same value.
  - id: string (required) — The ID of the webhook integration (e.g., "wh_1234567890abcdef")
  - project_id: string (required) — The ID of the project the webhook integration belongs to (e.g., "proj_1234567890abcdef")
  - name: string (required) — The display name of the webhook integration (e.g., "Customer updates webhook")
  - url: string (required) — The URL RevenueCat will send webhook notifications to (e.g., "https://hooks.example.com/revenuecat")
  - environment: enum: production, sandbox, , nullable (required) — The environment the webhook integration is configured for. Only events for the selected environment will be sent.
  - event_types: array, nullable — Event types that will trigger the webhook. Only events for the selected event types will be sent.
  - app_id: string, nullable (required) — The ID of the app the webhook integration is scoped to. If not provided, the webhook integration will be scoped to all apps in the project. (e.g., "app_1234567890abcdef")
  - created_at: integer(int64) (required) — The timestamp in ms since epoch when the webhook integration was created (e.g., 1658399423658)
- **Status:** public
