# Error Handling

RevenueCat uses [standard HTTP status codes](#tag/Error-Handling/Error-Codes) to indicate the success or failure of an API request. Codes in the `2XX` range indicate the request was successful. `4XX` codes indicate an error caused by the client. `5XX` codes indicate an error in RevenueCat servers.

Successful modifications return the modified entity. Errors return the following fields:

```json title="Sample Error Response"
{
  "type": "parameter_error",
  "param": "customer_id",
  "message": "id is too long",
  "retryable": false,
  "doc_url": "https://errors.rev.cat/parameter-error"
}
```

For more information on the `type` field and how to resolve these errors, please visit our [Error Types](#tag/Error-Handling/Error-Types) documentation.

## Error Codes

| Code | Name                  | Description                                                                                                                                                                                          |
| :--- | :-------------------- | :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 200  | OK                    | Processed as expected                                                                                                                                                                                |
| 201  | Created               | Entity was created                                                                                                                                                                                   |
| 202  | Accepted              | Request acknowledged, but cannot be processed in real time (for instance, async job)                                                                                                                 |
| 204  | No content            | The request was successful and there was no content that could be returned                                                                                                                           |
| 400  | Bad Request           | Client error                                                                                                                                                                                         |
| 401  | Unauthorized          | Not authenticated                                                                                                                                                                                    |
| 403  | Forbidden             | Authorization failed                                                                                                                                                                                 |
| 404  | Not Found             | No resource was found                                                                                                                                                                                |
| 409  | Conflict              | Uniqueness constraint violation                                                                                                                                                                      |
| 418  | I'm a teapot          | RevenueCat refuses to brew coffee                                                                                                                                                                    |
| 422  | Unprocessable entity  | The request was valid and the syntax correct, but we were unable to process the contained instructions.                                                                                              |
| 423  | Locked                | The request conflicted with another ongoing request                                                                                                                                                  |
| 429  | Too Many Requests     | Being [rate limited](#tag/Rate-Limit)                                                                                                                                                                 |
| 500  | Internal Server Error | The RevenueCat server ran into an unexpected problem – please check the [RevenueCat status page](https://status.revenuecat.com/) for any known outages and/or report the issue to RevenueCat support |
| 502  | Bad Gateway           | Invalid response from an upstream server                                                                                                                                                             |
| 503  | Service Unavailable   | There wasn’t a server to handle the request                                                                                                                                                          |
| 504  | Gateway Timeout       | We could not get the response in time from the upstream server                                                                                                                                       |
