# Entitlement

Operations about entitlements.

## Endpoints

### GET /projects/{project_id}/entitlements

Get a list of entitlements

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10), expand (query, optional) — Specifies which fields in the response should be expanded. Accepted values are: `items.product` (requires `project_configuration:products:read` permission).
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's entitlements. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/entitlements?starting_after=entlab21dac")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/entitlements")
- **Status:** public

### POST /projects/{project_id}/entitlements

Create an entitlement

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Body:**
  - lookup_key: string (required) — The identifier of the entitlement (e.g., "premium")
  - display_name: string (required) — The display name of the entitlement (e.g., "Premium access to all features")
- **Response:**
  - object: enum: entitlement (required) — String representing the object's type. Objects of the same type share the same value.
  - project_id: string (required) — ID of the project to which the entitlement belongs (e.g., "proj1ab2c3d4")
  - id: string (required) — The id of the entitlement (e.g., "entla1b2c3d4e5")
  - lookup_key: string (required) — A custom identifier of the entitlement (e.g., "premium")
  - display_name: string (required) — The display name of the entitlement (e.g., "Premium")
  - created_at: integer(int64) (required) — The date when the entitlement was created in ms since epoch (e.g., 1658399423658)
  - products: object, nullable — List of products attached to the entitlement
- **Status:** public

### DELETE /projects/{project_id}/entitlements/{entitlement_id}

Delete an entitlement

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), entitlement_id (path, required) — ID of the entitlement (e.g., "entla1b2c3d4e5")
- **Response:**
  - object: enum: app, customer, entitlement, offering, package, paywall, product, virtual_currency, webhook_integration (required) — The type of the deleted object
  - id: string (required) — The ID of the deleted object
  - deleted_at: integer(int64) (required) — The date when the object was deleted in ms since epoch (e.g., 1658399423658)
- **Status:** public

### GET /projects/{project_id}/entitlements/{entitlement_id}

Get an entitlement

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), entitlement_id (path, required) — ID of the entitlement (e.g., "entla1b2c3d4e5")
- **Query:** expand (query, optional) — Specifies which fields in the response should be expanded. Accepted values are: `product` (requires `project_configuration:products:read` permission).
- **Response:**
  - object: enum: entitlement (required) — String representing the object's type. Objects of the same type share the same value.
  - project_id: string (required) — ID of the project to which the entitlement belongs (e.g., "proj1ab2c3d4")
  - id: string (required) — The id of the entitlement (e.g., "entla1b2c3d4e5")
  - lookup_key: string (required) — A custom identifier of the entitlement (e.g., "premium")
  - display_name: string (required) — The display name of the entitlement (e.g., "Premium")
  - created_at: integer(int64) (required) — The date when the entitlement was created in ms since epoch (e.g., 1658399423658)
  - products: object, nullable — List of products attached to the entitlement
- **Status:** public

### POST /projects/{project_id}/entitlements/{entitlement_id}

Update an entitlement

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), entitlement_id (path, required) — ID of the entitlement (e.g., "entla1b2c3d4e5")
- **Body:**
  - display_name: string (required) — The display name of the entitlement (e.g., "Premium")
- **Response:**
  - object: enum: entitlement (required) — String representing the object's type. Objects of the same type share the same value.
  - project_id: string (required) — ID of the project to which the entitlement belongs (e.g., "proj1ab2c3d4")
  - id: string (required) — The id of the entitlement (e.g., "entla1b2c3d4e5")
  - lookup_key: string (required) — A custom identifier of the entitlement (e.g., "premium")
  - display_name: string (required) — The display name of the entitlement (e.g., "Premium")
  - created_at: integer(int64) (required) — The date when the entitlement was created in ms since epoch (e.g., 1658399423658)
  - products: object, nullable — List of products attached to the entitlement
- **Status:** public

### POST /projects/{project_id}/entitlements/{entitlement_id}/actions/attach_products

Attach a set of products to an entitlement

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), entitlement_id (path, required) — ID of the entitlement (e.g., "entla1b2c3d4e5")
- **Body:**
  - product_ids: array (required) — IDs of the products to be attached to the entitlement.
- **Response:**
  - object: enum: entitlement (required) — String representing the object's type. Objects of the same type share the same value.
  - project_id: string (required) — ID of the project to which the entitlement belongs (e.g., "proj1ab2c3d4")
  - id: string (required) — The id of the entitlement (e.g., "entla1b2c3d4e5")
  - lookup_key: string (required) — A custom identifier of the entitlement (e.g., "premium")
  - display_name: string (required) — The display name of the entitlement (e.g., "Premium")
  - created_at: integer(int64) (required) — The date when the entitlement was created in ms since epoch (e.g., 1658399423658)
  - products: object, nullable — List of products attached to the entitlement
- **Status:** public

### POST /projects/{project_id}/entitlements/{entitlement_id}/actions/detach_products

Detach a set of product from an entitlement

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), entitlement_id (path, required) — ID of the entitlement (e.g., "entla1b2c3d4e5")
- **Body:**
  - product_ids: array (required) — IDs of the products to be detached from the entitlement.
- **Response:**
  - object: enum: entitlement (required) — String representing the object's type. Objects of the same type share the same value.
  - project_id: string (required) — ID of the project to which the entitlement belongs (e.g., "proj1ab2c3d4")
  - id: string (required) — The id of the entitlement (e.g., "entla1b2c3d4e5")
  - lookup_key: string (required) — A custom identifier of the entitlement (e.g., "premium")
  - display_name: string (required) — The display name of the entitlement (e.g., "Premium")
  - created_at: integer(int64) (required) — The date when the entitlement was created in ms since epoch (e.g., 1658399423658)
  - products: object, nullable — List of products attached to the entitlement
- **Status:** public

### GET /projects/{project_id}/entitlements/{entitlement_id}/products

Get a list of products attached to a given entitlement

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), entitlement_id (path, required) — ID of the entitlement (e.g., "entla1b2c3d4e5")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the entitlement's products. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/entitlements/entla1b2c3d4e5/products?starting_after=prod1a2b3c4d5")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/entitlements/entla1b2c3d4e5/products")
- **Status:** public
