# Customer

Operations about customers.

## Endpoints

### GET /projects/{project_id}/customers

Get a list of customers

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10), search (query, optional) — Search term. Currently, only searching by email is supported (searching for exact matches in the $email attribute). (e.g., "example@example.com")
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the project's customers. If not present / null, there is no next page (e.g., "/v2/projects/projec1a2b3c4d/customers?starting_after=223xx1100")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/projec1a2b3c4d/customers")
- **Status:** public

### POST /projects/{project_id}/customers

Create a customer

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Body:**
  - id: string (required) — The ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - attributes: array
- **Response:**
  - object: enum: customer (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - project_id: string (required) — ID of the project to which the customer belongs (e.g., "proj1ab2c3d4")
  - first_seen_at: integer(int64) (required) — The first time the customer was seen (e.g., 1658399423658)
  - last_seen_at: integer(int64), nullable (required) — The last time the customer was seen (e.g., 1658399423658)
  - last_seen_app_version: string, nullable (required) — The last app version the customer was seen on (e.g., "1.0.0")
  - last_seen_country: string, nullable (required) — The last country the customer was seen in (e.g., "US")
  - last_seen_platform: string, nullable (required) — The last platform the customer was seen on (e.g., "android")
  - last_seen_platform_version: string, nullable (required) — The last platform version the customer was seen on (e.g., "35")
  - active_entitlements: object — List of the entitlements currently active for the customer. This property is only available in the "Get a customer" endpoint.
  - experiment: object, nullable — The experiment enrollment object
  - attributes: object — List of the attributes of the customer. This is an expandable property, only available in the "Get a customer" endpoint.
- **Status:** public

### DELETE /projects/{project_id}/customers/{customer_id}

Delete a customer

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Response:**
  - object: enum: app, customer, entitlement, offering, package, paywall, product, virtual_currency, webhook_integration (required) — The type of the deleted object
  - id: string (required) — The ID of the deleted object
  - deleted_at: integer(int64) (required) — The date when the object was deleted in ms since epoch (e.g., 1658399423658)
- **Status:** public

### GET /projects/{project_id}/customers/{customer_id}

Get a customer

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** expand (query, optional) — Specifies which fields in the response should be expanded. Accepted values are: `attributes` (requires `customer_information:customers:read` permission).
- **Response:**
  - object: enum: customer (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - project_id: string (required) — ID of the project to which the customer belongs (e.g., "proj1ab2c3d4")
  - first_seen_at: integer(int64) (required) — The first time the customer was seen (e.g., 1658399423658)
  - last_seen_at: integer(int64), nullable (required) — The last time the customer was seen (e.g., 1658399423658)
  - last_seen_app_version: string, nullable (required) — The last app version the customer was seen on (e.g., "1.0.0")
  - last_seen_country: string, nullable (required) — The last country the customer was seen in (e.g., "US")
  - last_seen_platform: string, nullable (required) — The last platform the customer was seen on (e.g., "android")
  - last_seen_platform_version: string, nullable (required) — The last platform version the customer was seen on (e.g., "35")
  - active_entitlements: object — List of the entitlements currently active for the customer. This property is only available in the "Get a customer" endpoint.
  - experiment: object, nullable — The experiment enrollment object
  - attributes: object — List of the attributes of the customer. This is an expandable property, only available in the "Get a customer" endpoint.
- **Status:** public

### POST /projects/{project_id}/customers/{customer_id}/actions/assign_offering

Assign or clear an offering override for a customer

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Body:**
  - offering_id: string, nullable (required) — The ID of the offering to assign to the customer. Set to null to clear any existing override. (e.g., "offrng1b2c3d4e5")
- **Response:**
  - (empty)
- **Status:** public

### POST /projects/{project_id}/customers/{customer_id}/actions/grant_entitlement

Grant an entitlement to a customer unless one already exists. As a side effect, a promotional subscription is created.

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Body:**
  - entitlement_id: string (required) — The ID of the entitlement to grant to the customer. (e.g., "entla1b2c3d4e5")
  - expires_at: integer(int64) (required) — The date after which the access to the entitlement expires in ms since epoch. (e.g., 1658399423658)
- **Response:**
  - object: enum: customer (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - project_id: string (required) — ID of the project to which the customer belongs (e.g., "proj1ab2c3d4")
  - first_seen_at: integer(int64) (required) — The first time the customer was seen (e.g., 1658399423658)
  - last_seen_at: integer(int64), nullable (required) — The last time the customer was seen (e.g., 1658399423658)
  - last_seen_app_version: string, nullable (required) — The last app version the customer was seen on (e.g., "1.0.0")
  - last_seen_country: string, nullable (required) — The last country the customer was seen in (e.g., "US")
  - last_seen_platform: string, nullable (required) — The last platform the customer was seen on (e.g., "android")
  - last_seen_platform_version: string, nullable (required) — The last platform version the customer was seen on (e.g., "35")
  - active_entitlements: object — List of the entitlements currently active for the customer. This property is only available in the "Get a customer" endpoint.
  - experiment: object, nullable — The experiment enrollment object
  - attributes: object — List of the attributes of the customer. This is an expandable property, only available in the "Get a customer" endpoint.
- **Status:** public

### POST /projects/{project_id}/customers/{customer_id}/actions/revoke_granted_entitlement

Revoke a granted entitlement from a customer. As a side effect, the promotional subscription associated with the granted entitlement is expired.

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Body:**
  - entitlement_id: string (required) — The ID of the granted entitlement to revoke from the customer. (e.g., "entla1b2c3d4e5")
- **Response:**
  - object: enum: customer (required) — String representing the object's type. Objects of the same type share the same value.
  - id: string (required) (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
  - project_id: string (required) — ID of the project to which the customer belongs (e.g., "proj1ab2c3d4")
  - first_seen_at: integer(int64) (required) — The first time the customer was seen (e.g., 1658399423658)
  - last_seen_at: integer(int64), nullable (required) — The last time the customer was seen (e.g., 1658399423658)
  - last_seen_app_version: string, nullable (required) — The last app version the customer was seen on (e.g., "1.0.0")
  - last_seen_country: string, nullable (required) — The last country the customer was seen in (e.g., "US")
  - last_seen_platform: string, nullable (required) — The last platform the customer was seen on (e.g., "android")
  - last_seen_platform_version: string, nullable (required) — The last platform version the customer was seen on (e.g., "35")
  - active_entitlements: object — List of the entitlements currently active for the customer. This property is only available in the "Get a customer" endpoint.
  - experiment: object, nullable — The experiment enrollment object
  - attributes: object — List of the attributes of the customer. This is an expandable property, only available in the "Get a customer" endpoint.
- **Status:** public

### POST /projects/{project_id}/customers/{customer_id}/actions/transfer

Transfer customer's subscriptions and one-time purchases to another customer

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Body:**
  - target_customer_id: string (required) — The ID of the customer to whom the subscriptions and one-time purchases will be transferred.
  - app_ids: array, nullable — Optional. The IDs of the apps to filter the transfer by. When specified, only purchases and subscriptions associated with these apps will be transferred.
- **Response:**
  - source_customer: object (required) — The original customer before the transfer
  - target_customer: object (required) — The target customer after the transfer
- **Status:** public

### GET /projects/{project_id}/customers/{customer_id}/active_entitlements

Get a list of customer's active entitlements

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's active entitlements. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/active_entitlements?starting_after=entlab21dac")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/active_entitlements")
- **Status:** public

### GET /projects/{project_id}/customers/{customer_id}/aliases

Get a list of the customer's aliases

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's aliases. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/aliases?starting_after=9fjeja8fjed")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/aliases")
- **Status:** public

### GET /projects/{project_id}/customers/{customer_id}/attributes

Get a list of the customer's attributes

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's aliases. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/attributes?starting_after=myCustomAttribute")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/attributes")
- **Status:** public

### POST /projects/{project_id}/customers/{customer_id}/attributes

Set a customer's attributes

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Body:**
  - attributes: array (required)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's aliases. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/attributes?starting_after=myCustomAttribute")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/attributes")
- **Status:** public

### GET /projects/{project_id}/customers/{customer_id}/purchases

Get a list of purchases associated with a customer

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** environment (query, optional) (e.g., "production"), starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's purchases. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/purchases?starting_after=purc1a2b3c4d5e")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/purchases")
- **Status:** public

### GET /projects/{project_id}/customers/{customer_id}/subscriptions

Get a list of subscriptions associated with a customer

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** environment (query, optional) (e.g., "production"), starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's subscriptions. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/subscriptions?starting_after=sub1a2b3c4d")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/subscriptions")
- **Status:** public

### GET /projects/{project_id}/customers/{customer_id}/virtual_currencies

Get a list of customer's virtual currencies balances

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** include_empty_balances (query, optional) (e.g., true), starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's balances. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/virtual_currencies?starting_after=9fjeja8fjed")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/virtual_currencies")
- **Status:** public

### POST /projects/{project_id}/customers/{customer_id}/virtual_currencies/transactions

Create a virtual currencies transaction

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** include_empty_balances (query, optional) (e.g., true)
- **Body:**
  - adjustments: object (required) — The adjustments to the virtual currencies
  - reference: string, nullable — The reference of the transaction
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's balances. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/virtual_currencies?starting_after=9fjeja8fjed")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/virtual_currencies")
- **Status:** public

### POST /projects/{project_id}/customers/{customer_id}/virtual_currencies/update_balance

Update a virtual currencies balance without creating a transaction

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** include_empty_balances (query, optional) (e.g., true)
- **Body:**
  - adjustments: object (required) — The adjustments to the virtual currencies
  - reference: string, nullable — The reference of the transaction
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's balances. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/virtual_currencies?starting_after=9fjeja8fjed")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/virtual_currencies")
- **Status:** public

# Invoice

Operations about invoices.

## Endpoints

### GET /projects/{project_id}/customers/{customer_id}/invoices

Get a list of the customer's invoices

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Query:** starting_after (query, optional) (e.g., "ent12354"), limit (query, optional, default: 20) (e.g., 10)
- **Response:**
  - object: enum: list (required) — String representing the object's type. Objects of the same type share the same value. Always has the value `list`.
  - items: array (required) — Details about each object.
  - next_page: string, nullable (required) — URL to access the next page of the customer's invoice. If not present / null, there is no next page (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/invoices?starting_after=rcbin1a2b3c4d5e")
  - url: string (required) — The URL where this list can be accessed. (e.g., "/v2/projects/proj1ab2c3d4/customers/19b8de26-77c1-49f1-aa18-019a391603e2/invoices")
- **Status:** public

### GET /projects/{project_id}/customers/{customer_id}/invoices/{invoice_id}/file

Get an invoice

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2"), invoice_id (path, required) — ID of the invoice (e.g., "rcbin1a2b3c4d5e")
- **Status:** public

### GET /projects/{project_id}/customers/blocked_customers

List blocked customers

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4")
- **Response:**
  - object: enum: blocked_customer (required) — String representing the object's type. Objects of the same type share the same value.
- **Status:** beta





### DELETE /projects/{project_id}/customers/blocked_customers/{customer_id}

Remove a customer from the block list

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Response:**
  - (empty)
- **Status:** beta





### POST /projects/{project_id}/customers/blocked_customers/{customer_id}

Add a customer to the block list

- **Params:** project_id (path, required) — ID of the project (e.g., "proj1ab2c3d4"), customer_id (path, required) — ID of the customer (e.g., "19b8de26-77c1-49f1-aa18-019a391603e2")
- **Response:**
  - (empty)
- **Status:** beta

# Invoice

Operations about invoices.

## Endpoints
