# RevenueCat Developer API v2 Reference

## Base URL
```
https://api.revenuecat.com/v2
```

## Authentication
Bearer HTTP authentication. Allowed headers -- Authorization: Bearer <api_key>

## Pagination

Top-level API resources have support for bulk fetches via "list" API methods. For instance, you can list products, list entitlements, and list offerings. These list API methods share a common structure, taking at least these two parameters: `limit` and `starting_after`.

When a response or a field contains multiple entities of the same type, it returns a `list` object of the following structure:

```json title="JSON"
{
  "object": "list",
  "items": [{}],
  "next_page": "LIST_BASE_URL?starting_after=LAST_ID",
  "url": "LIST_BASE_URL"
}
```

Where…

- `url` is the full path base URL of the list endpoint (i.e., if you make a request to this endpoint, you will get the first page), e.g. `/v2/projects/{project_id}/products`
- `next_page` is the URL for the next page, if there is one. If there is no next page, the `next_page` field will not be present. Example: `/v2/projects/{project_id}/products?starting_after={last_id}`
- `items` is an array of the entries of the list.

The `starting_after` query parameter of list endpoints accepts the ID of the first list item that will not be part of the list (in other words, the ID of the last item of the previous page).

At the moment we only support forward pagination.

### Parameters
`limit` _optional, default is 20_

A limit on the number of objects to be returned.

`starting_after` _optional_

A cursor for use in pagination. `starting_after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 20 objects, ending with foo, your subsequent call can include `starting_after=foo` in order to fetch the next page of the list.

## Expandable Fields

Expandables allow you to retrieve related data along with the request without making additional requests. Fields in the REST API will allow you to request additional information as an expanded response by using the `expand` query parameter.

For example, a `product` object will have an associated `app_id` field. This `app_id` field can be expanded in the same request with the `expand` query parameter and will include an `app` object in the response.

## Additional References

- [rate-limits.md](./rate-limits.md)
- [error-handling.md](./error-handling.md)


---

## API Domain References

The API is organized by domain for progressive disclosure. Each domain contains related endpoints:

### [projects.md](./projects.md)
- App — Operations about apps.
- Collaborator — Operations about collaborators.
- Project — Operations about projects.

### [audit-logs.md](./audit-logs.md)
- Audit Log — Operations about audit logs.

### [metrics.md](./metrics.md)
- Charts & Metrics — Operations about chart metrics.

### [customers.md](./customers.md)
- Customer — Operations about customers.
- Invoice — Operations about invoices.

### [entitlements.md](./entitlements.md)
- Entitlement — Operations about entitlements.

### [offerings.md](./offerings.md)
- Offering — Operations about offerings.
- Package — Operations about packages.

### [products.md](./products.md)
- Product — Operations about products.

### [virtual-currencies.md](./virtual-currencies.md)
- Virtual Currency — Operations about virtual currencies.

### [purchases.md](./purchases.md)
- Purchase — Operations about purchases.

### [subscriptions.md](./subscriptions.md)
- Subscription — Operations about subscriptions.

### [paywalls.md](./paywalls.md)
- Paywall — Operations about paywalls.

### [integrations.md](./integrations.md)
- Integration — Operations about integrations.
