# Resume Tailoring

## Job Description Parsing

When user provides a job posting:

### Extract Requirements
```
MUST-HAVE (explicit requirements):
- "X years experience in Y"
- "Proficiency in Z"
- Anything after "required" or "must have"

NICE-TO-HAVE (differentiators):
- Anything after "preferred" or "bonus"
- Skills mentioned once, not repeated
```

### Keyword Extraction
- Pull exact phrases from JD (not paraphrased)
- Note both spelled-out and acronym forms: "Search Engine Optimization (SEO)"
- Identify action verbs they use: "drive", "lead", "own" vs "support", "assist"
- Count frequency — repeated terms are priorities

---

## Mapping Experience to Requirements

Create mental match table:

| JD Requirement | User's Evidence | Match Quality |
|----------------|-----------------|---------------|
| "5+ years Python" | 6 years at X company | ✅ Strong |
| "Team leadership" | "Mentored 2 juniors" | 🟡 Weak — reframe |
| "Machine learning" | None | ❌ Gap |

For weak matches → find better evidence or reframe existing.
For gaps → acknowledge honestly or find adjacent experience.

---

## Keyword Integration

**Natural placement (good):**
- In achievement context: "Implemented CI/CD pipeline reducing deploy time 40%"
- In skills section as list item
- In summary if highly relevant

**Stuffing (bad):**
- Same keyword repeated 5+ times
- Keywords without context: "Python, Python development, Python programming"
- Hidden text (white on white) — ATS catches this

**Target density:** Keyword appears 2-3 times max across resume.

---

## Section Reordering

Default order for experienced professionals:
1. Contact + Title
2. Summary (optional)
3. Experience
4. Skills
5. Education

**When to change:**

| Situation | Recommended Order |
|-----------|-------------------|
| Strong direct experience | Experience → Skills → Education |
| Career changer | Summary → Skills → Experience (reframed) |
| Recent graduate | Education → Projects → Skills → Experience |
| Technical role | Skills (prominent) → Experience → Education |
| Executive | Summary → Experience (selected highlights) → Earlier Career (condensed) |

---

## Industry Translation

When user is changing industries, translate vocabulary:

| From (Hospitality) | To (Product Management) |
|--------------------|-----------------------|
| Guest satisfaction | User experience / NPS |
| Front desk management | Operations ownership |
| Vendor coordination | Stakeholder management |
| Complaint resolution | Issue escalation and resolution |
| Event planning | Program management |

| From (Military) | To (Corporate) |
|-----------------|----------------|
| Platoon leader | Team manager |
| Mission planning | Project planning |
| After-action review | Retrospective / post-mortem |
| Logistics | Supply chain / operations |
| Intel | Research / competitive analysis |

**Process:**
1. Identify jargon from source industry
2. Find equivalent concept in target industry
3. Rewrite achievements using target vocabulary
4. Verify the translation makes sense to target audience

---

## Narrative Bridges for Career Changers

Template:
> "[Current/past] experience in [X] developed my expertise in [transferable skill]. Now I'm applying that to [target field] because [genuine reason]."

**Examples:**

Hospitality → Product:
> "Managing high-volume restaurant operations taught me to obsess over user experience and make rapid decisions with incomplete data. I'm bringing that operational rigor to product management."

Finance → Sustainability:
> "A decade in investment banking gave me deep understanding of how capital flows. I'm now channeling that expertise toward financing the energy transition."

**Red flags to avoid:**
- "Seeking new challenges" (vague)
- "Burnt out in previous field" (negative)
- "Always been passionate about..." without evidence (unbelievable)
