# Seniority Calibration

## Career Level Patterns

### Junior (0-3 years)
**Challenge:** Not enough experience.
**Strategy:** Maximize what you have.

- Lead with education if prestigious or recent
- Highlight projects, internships, coursework
- Emphasize growth potential, adaptability
- Include relevant skills prominently
- One page maximum

### Mid-Level (4-9 years)
**Challenge:** Standing out from the crowd.
**Strategy:** Show trajectory and ownership.

- Experience section is star
- Each role shows progression
- Quantified achievements essential
- Skills section supports, doesn't lead
- One to two pages

### Senior (10-15 years)
**Challenge:** Too much to fit.
**Strategy:** Curate ruthlessly.

- Only highlight relevant experience
- Older roles condensed (company, title, years only)
- Leadership and impact emphasized
- Two pages maximum
- Summary useful to frame narrative

### Executive (15+ years)
**Challenge:** Not appearing overqualified OR underqualified.
**Strategy:** Tell a story, not list a history.

- Career arc as narrative
- Board-level impact language
- Strategic achievements, not tactical tasks
- Can extend to 2-3 pages if necessary
- Earlier career: "Previous experience at [companies]"

---

## Condensing Techniques

### Recency Weighting
```
Last 5-7 years:     Full detail (3-5 bullets each)
8-15 years ago:     Brief (1-2 bullets each)
15+ years ago:      One line or group as "Earlier: [Role] at [Co], [Role] at [Co]"
```

### Career Arc Synthesis
Instead of 12 separate roles, show one progression:

❌ **Before (fragmented):**
- Software Engineer, Company A (2008-2010)
- Senior Engineer, Company B (2010-2013)
- Tech Lead, Company C (2013-2016)
- Engineering Manager, Company D (2016-2019)
- VP Engineering, Company E (2019-Present)

✅ **After (narrative):**
> "Progressed from IC to VP Engineering across [industries], building and scaling teams from 3 to 50+. Most recent: VP Engineering at Company E leading platform modernization."

Then detail only current + most relevant past role.

---

## Achievement Distillation

When user has 50+ achievements to choose from:

### Selection criteria:
1. **Relevance** — Does it matter for target role?
2. **Impact** — Is there a quantifiable result?
3. **Recency** — Prefer recent over old
4. **Uniqueness** — Does it differentiate from competitors?
5. **Scale** — Bigger impact > smaller (usually)

### Distillation process:
1. List all achievements
2. Score each 1-5 on relevance to target
3. Keep only 4s and 5s
4. From those, keep 8-10 maximum
5. Distribute across recent roles (more for current role)

---

## Role-Level Calibration

When targeting a specific level that's different from current:

### Targeting Lower Level (avoid "overqualified" rejection)

**Do:**
- Emphasize hands-on work, not just strategy
- Show you still do the work, not just delegate
- Express genuine interest in IC/tactical work
- Mention why you want this level (be ready for interview)

**Don't:**
- Lead with "managed 100 people"
- Use executive-only language ("drove strategy")
- List only high-level achievements
- Include salary expectations that signal senior

### Targeting Higher Level (avoid "not ready" rejection)

**Do:**
- Emphasize leadership moments, even informal
- Quantify scope: team size, budget, revenue impact
- Show strategic thinking, not just execution
- Include relevant executive education/certifications

**Don't:**
- Lead with individual contributor work
- Use junior language ("helped with", "assisted")
- Downplay scope or impact

---

## Strategic Omissions

What to consider removing:

| Element | Remove If |
|---------|----------|
| Graduation year | >15 years ago (age signal) |
| Early jobs | Irrelevant or >15 years ago |
| Old certifications | Expired or obsolete tech |
| Hobbies | Unless directly relevant |
| References line | "Available upon request" is assumed |
| Full address | City, State sufficient |
| Photo | Never in US, usually remove elsewhere |

### How to omit without looking suspicious:

- **Gap in dates?** Group early career: "2005-2015: Various roles in X industry"
- **Short stint?** Consider omitting entirely if < 6 months
- **Demotion?** Remove titles that break progression narrative
- **Fired?** Not the resume's job to explain — that's for interview

---

## Legacy Translation

Old tech/context that needs updating:

| Old | Modern Equivalent |
|-----|-------------------|
| On-premise servers | Infrastructure management (cloud-adjacent) |
| Waterfall projects | Sequential delivery / phased rollouts |
| COBOL, mainframes | Enterprise systems, legacy modernization |
| Lotus Notes, Blackberry | Enterprise communication platforms |
| Cold calling | Outbound sales development |

**Rule:** Describe the SKILL, not the specific outdated tool.
- ❌ "Managed Sun Microsystems servers"
- ✅ "Managed enterprise server infrastructure, later led cloud migration"
