# Resume Diagnosis

## Why Aren't They Calling?

When user's resume isn't generating interviews, diagnose systematically:

### Check 1: Targeting Problem
- Is the resume generic or tailored to specific roles?
- Does the title/summary match what they're applying for?
- Are keywords from job descriptions present?

**Fix:** Tailor to each application. See `tailoring.md`.

### Check 2: Positioning Problem
- Responsibilities listed instead of achievements?
- Impact not quantified?
- Skills claimed without evidence?

**Transform test:** Can each bullet answer "So what?"
- "Managed customer accounts" → So what?
- "Managed 50 enterprise accounts generating $2M ARR with 95% retention" → Clear value.

### Check 3: Format Problem
- Is it passing ATS? (See `ats.md`)
- Too long for experience level?
- Visually hard to scan?

### Check 4: Red Flags Present
- Employment gaps unexplained?
- Too many short stints?
- Overqualified signals?
- Typos or inconsistencies?

---

## Diagnostic Questions

Ask user:
1. How many applications sent in last month?
2. How many callbacks/rejections/silence?
3. Are you applying to roles that match your experience level?
4. Are you tailoring or using same resume everywhere?
5. Do you know if applications reach humans or just ATS?

---

## Common Diagnoses

| Symptom | Likely Cause | Fix |
|---------|--------------|-----|
| 50+ apps, 0 calls | ATS filtering OR severe mismatch | Check ATS compatibility, verify targeting |
| Some calls but wrong roles | Resume signals wrong | Clarify title, reposition summary |
| Calls but no offers | Interview problem, not resume | Outside resume scope |
| Only callbacks from recruiters | Resume works but applying to wrong places | Targeting problem |

---

## The Honest Assessment

Sometimes the resume isn't the problem:

- **Skill gap:** Targeting roles requiring skills they don't have
- **Market timing:** Industry downturn, hiring freezes
- **Experience mismatch:** Senior applying to junior (or vice versa)
- **Location constraint:** Remote-only in RTO market

**Agent should:** Be direct about this. Don't optimize a resume for an impossible target.

---

## Gap Analysis

When comparing resume to target role:

```
Required by role    | In resume | Status
--------------------|-----------|--------
Python 5+ years     | 3 years   | ⚠️ Short — can reframe?
AWS certification   | None      | ❌ Hard gap
Team leadership     | Yes       | ✅ Covered
Agile experience    | Implied   | 🟡 Make explicit
```

For hard gaps:
- Can experience be reframed? ("Used Python for 3 years full-time" > "3 years")
- Is there adjacent/related experience? ("No AWS but extensive GCP")
- Is this a dealbreaker or a nice-to-have?

---

## Competitive Positioning

If user knows who they're competing against:

**Junior competing against seniors:**
- Lead with energy, adaptability, recent training
- Highlight cutting-edge skills seniors may lack
- Emphasize growth trajectory

**Senior competing against juniors:**
- Lead with results and track record
- Show you won't be "too expensive to manage"
- Demonstrate current skills, not legacy ones

**Career changer competing against direct experience:**
- Lead with transferable outcomes, not tasks
- Build credibility through certifications, projects
- Position change as strength: "fresh perspective"
