---
name: Resume
description: Adapt, diagnose, and optimize resumes to land interviews with ATS optimization, job-specific tailoring, and recruiter-tested tactics.
version: 1.0.0
metadata: {"clawdbot":{"emoji":"📄","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Quick Reference

| File | Purpose |
|------|---------|
| `tailoring.md` | Adapt resume to specific job postings |
| `diagnosis.md` | Find why resume isn't getting calls |
| `ats.md` | Pass automated screening systems |
| `seniority.md` | Calibrate for different career levels |

---

## What the Agent Can Do

| User Request | Agent Action |
|--------------|--------------|
| "Why am I not getting calls?" | Diagnose: match gaps, red flags, weak positioning |
| "Tailor this to [job posting]" | Extract keywords, reorder, adapt language |
| "Will this pass ATS?" | Check format, keywords, parseability |
| "I'm changing careers" | Identify transferable skills, build narrative bridge |
| "Condense 15 years to 2 pages" | Prioritize recent impact, strategic omissions |
| "Is my experience positioned well?" | Convert responsibilities → achievements |

---

## The 6-Second Test

Recruiters scan resumes in 6 seconds. Before anything else, verify:

1. **Title clarity** — Current/target role obvious at top?
2. **Impact visible** — Top 3 achievements jump out?
3. **Relevance clear** — Match to target role evident?
4. **Clean format** — No visual clutter slowing scan?

If any fail → fix before other optimizations.

---

## Responsibilities → Achievements

The #1 resume killer: listing tasks instead of results.

**Transform pattern:**
- "Responsible for..." → "Achieved X resulting in Y"
- "Managed team of..." → "Built team from X to Y, delivering Z"
- "Worked on..." → "Led/contributed to X, increasing Y by Z%"

**Every bullet needs:** Action verb + specific result + quantified impact when possible.

---

## Tailoring Workflow

When adapting to a specific job:

1. **Extract requirements** — Parse job description for must-haves vs nice-to-haves
2. **Map experience** — Which of user's achievements match each requirement?
3. **Identify gaps** — What's missing? Can it be reframed or is it a real gap?
4. **Inject keywords** — Add exact terms from JD, naturally integrated
5. **Reorder sections** — Most relevant experience first

See `tailoring.md` for job description parsing patterns.

---

## Career Changers

When user is switching industries/roles:

1. **Vocabulary translation** — Rewrite achievements in target industry language
2. **Transferable skills** — Extract hidden competencies ("budget management" = "P&L ownership")
3. **Narrative bridge** — 2-3 sentences connecting past to future coherently
4. **Section reorder** — Skills/summary may go before experience
5. **Red flag check** — Avoid phrases that signal confusion about direction

See `tailoring.md` section on industry translation.

---

## Senior/Executive Resumes

15+ years of experience requires different approach:

1. **Career arc** — One coherent progression, not 12 disconnected roles
2. **Recency weighting** — Last 5-7 years detailed, earlier roles condensed
3. **Strategic omissions** — Remove outdated tech, irrelevant roles, age signals
4. **Leadership evidence** — Show HOW you led, not just that you did
5. **Role calibration** — Adjust tone if targeting lower level (avoid "overqualified" rejection)

See `seniority.md` for condensing techniques.

---

## Red Flags to Fix

Immediate disqualification triggers:

- **Unexplained gaps** — Address or the recruiter imagines worst
- **Job hopping without context** — Brief roles need positioning
- **Typos in tech names** — ReactJS vs React.js matters
- **Generic objective** — "Seeking challenging opportunity" = delete
- **Skills mismatch** — Claims that experience doesn't support

---

## Format Rules

- **Length:** <10 years = 1 page, 10-20 = 2 pages, exec = 2-3
- **File:** Have PDF, DOCX, and plain text versions ready
- **Design:** One column safer for ATS, minimal color, no graphics
- **Dates:** Consistent format throughout (MM/YYYY or Month YYYY)

For ATS-specific formatting, see `ats.md`.
