---
name: resume-screener-pro
description: 完整招聘解决方案 - 四阶段一站式流程（简历筛选→面试设计→面试评估→最终推荐）。整合Topgrading方法论、绩效预测和bias控制，适合HR招聘负责人、猎头、面试官使用。
---

# 简历筛选助手Pro - 完整招聘解决方案

> 版本：1.0.0 | 用途：完整招聘流程（筛选→面试设计→评估→推荐）

---

## 核心能力

本Skill整合完整招聘流程，四阶段一站式解决方案：

```
简历筛选 → 面试题目设计 → 面试评估 → 最终推荐
```

---

## 阶段一：简历筛选

### 输入
- 候选人简历（PDF/DOCX/TXT）
- 岗位JD

### 流程
1. **信息提取** - 解析简历关键信息（姓名、经历、技能、成就）
2. **JD匹配** - 对照JD要求打分（学历、经验、技能、素质）
3. **排名输出** - 生成候选人排名表

### 输出格式
```
【简历筛选报告】

| 候选人 | 匹配度 | 核心优势 | 风险点 | 推荐 |
|--------|--------|----------|--------|------|
| 张三   | 9.0    | 5年经验  | 薪资高 | ✅   |
| 李四   | 7.5    | 激情足   | 经验浅 | ⚠️   |
```

---

## 阶段二：面试题目设计

### 方法论
- **Geoff Smart (Topgrading)** - Scorecard定义 + 事实核查
- **Lou Adler (绩效预测)** - 过去表现预测未来
- **Daniel Kahneman (防偏)** -  bias控制

### 流程
1. **Scorecard定义** - 先不看简历！根据JD定义"A级人才"标准
   - Mission：岗位核心使命
   - Outcomes：12个月必须达成的可量化结果
   - Competencies：硬/软技能要求

2. **候选人画像分析** - 从简历提取：
   -  - 关键成就核心经历
  
   - 潜在风险点
   - 经验迁移点

3. **问题设计 - 剥洋葱原理**
   
   **第一层：STAR法则（行为面试）**
   - Situation（情况）：当时的具体情况是什么？
   - Task（任务）：你的具体任务是什么？
   - Action（行动）：你具体做了什么？
   - Result（结果）：最终结果如何？
   
   **第二层：深挖挑战（行为面试）**
   - 当时遇到了什么挑战/困难？
   - 你如何克服这些困难？
   - 克服困难的逻辑是什么？
   
   **第三层：底层校验（情景模拟）**
   - 底层逻辑校验：如果再来一次，你能做得更好吗？
   - 自身成长校验：现在回顾这段经历，你学到了什么？
   - 情景变更：如果情况发生变化，你的做法会如何调整？

### 输出格式
```
【面试问题清单】

一、必问通用问题
| 问题 | 考察点 |
|------|-------|
| 请用2分钟介绍你的工作经历 | 表达结构化 |
| 你为什么离开上一家公司？ | 动机/稳定性 |

二、针对[候选人姓名]的剥洋葱面试

**第一层：STAR法则**
- 请详细描述当时的具体情况（Situation）？
- 你的具体任务是什么（Task）？
- 你具体做了哪些行动（Action）？
- 最终结果如何（Result）？

**第二层：深挖挑战**
- 当时遇到了什么挑战/困难？
- 你如何克服这些困难？
- 克服困难的逻辑是什么？

**第三层：底层校验**
- 如果再来一次，你能做得更好吗？
- 现在回顾这段经历，你学到了什么？
- 如果情况发生变化，你的做法会如何调整？
- 如果你加入我们负责[岗位]，你会如何制定第一个季度的路线图？
```

---

## 阶段三：面试评估

### 方法论
根据岗位类型激活最佳专家组合：

| 角色类型 | 专家 | 职责 |
|---------|------|------|
| 产品经理 | Marty Cagan / Julie Zhuo | 产品sense |
| 工程师 | Linus Torvalds / John Carmack | 技术判断 |
| 设计师 | Don Norman / Jony Ive | 设计原则 |
| 销售 | Aaron Ross / Jill Konrath | 销售方法 |
| 数据科学家 | Andrew Ng / DJ Patil | 技术深度 |
| 招聘验证 | Geoff Smart | 事实核查 |
| 能力验证 | Lou Adler | 绩效验证 |
| 防偏 | Daniel Kahneman | bias控制 |

### 评估维度
| 维度 | 评价标准 | 评分(1-5) |
|------|---------|-----------|
| 岗位理解 | 对岗位的理解深度 | 1-5 |
| 问题解决 | 回答的逻辑性和可行性 | 1-5 |
| 经验迁移 | 能力迁移到新岗位的潜力 | 1-5 |
| 团队管理 | 管理理念和案例 | 1-5 |
| 文化匹配 | 价值观和动机 | 1-5 |

### 输出格式
```
【候选人姓名】面试评估报告

一、核心亮点
-

二、风险预警（红绿灯）
- 绿灯信号：...
- 红灯信号：...

三、各维度评分
| 维度 | 评分 | 说明 |
|------|------|------|
| 岗位理解 | X | ... |
| 问题解决 | X | ... |

四、综合评分：X/5

五、推荐结论
- 推荐/谨慎推荐/不推荐
- 理由：...
```

---

## 阶段四：最终推荐

### 决策矩阵
| 简历筛选 | 面试评估 | 最终结论 |
|---------|---------|---------|
| 9.0+ | 5/5 | 强烈推荐 ✅ |
| 8.5+ | 4.5/5 | 推荐 ✅ |
| 7.5+ | 4/5 | 谨慎推荐 ⚠️ |
| <5.5 | <3.5/5 | 不推荐 ❌ |

---

## 使用场景

| 用户需求 | 触发阶段 |
|----------|---------|
| "帮我筛选这批简历" | 阶段一 |
| "设计这个岗位的面试题" | 阶段二 |
| "评估这个候选人的面试表现" | 阶段三 |
| "综合推荐最终人选" | 阶段四 |
| "帮我做完整的招聘流程" | 全部阶段 |

---

## 注意事项

1. **先Scorecard再筛简历** - 不要先看简历再定标准！
2. **行为面试要深挖** - 用STAR法则层层追问，从具体行为看真实能力
3. **评估要客观** - 同时找绿灯和红灯信号
4. **决策基于数据** - 综合简历+面试多维度评估

---

## 配套Skills

如需更深入功能，可调用：
- `resume` - 简历优化
- `interview-designer` - 面试设计
- `interview-analysis` - 面试评估
- `interview-coach-ai` - 面试教练
