# Resume Best Practices

Core principles for creating effective, professional resumes.

## Table of Contents
1. [Content Principles](#content-principles)
2. [Writing Guidelines](#writing-guidelines)
3. [Format Standards](#format-standards)
4. [Section-Specific Guidance](#section-specific-guidance)
5. [Common Mistakes](#common-mistakes)

---

## Content Principles

### Achievement Over Responsibility
Transform duty descriptions into impact statements.

**Formula:** Action Verb + Task + Result/Impact

**Examples:**
- ❌ "Responsible for managing social media accounts"
- ✅ "Grew Instagram following from 2K to 45K in 8 months through targeted content strategy"

- ❌ "Worked on improving customer satisfaction"
- ✅ "Increased customer satisfaction scores from 3.2 to 4.6/5.0 by redesigning onboarding process"

### Quantify Everything Possible
Include metrics wherever available:
- Percentages: "Reduced costs by 23%"
- Dollar amounts: "Generated $1.2M in new revenue"
- Time savings: "Cut processing time from 3 days to 4 hours"
- Scale: "Managed team of 12", "Served 500+ customers daily"
- Frequency: "Published 3 articles weekly", "Conducted 15+ interviews monthly"

### STAR Method for Achievements
- **S**ituation: Context or challenge
- **T**ask: Your responsibility
- **A**ction: What you did
- **R**esult: Measurable outcome

### Relevance Over Completeness
- Tailor content to target position
- Emphasize transferable skills for career transitions
- Recent experience deserves more detail than older positions
- Omit irrelevant experience unless it fills gaps

---

## Writing Guidelines

### Action Verbs by Category

**Leadership:** Led, Directed, Managed, Supervised, Coordinated, Oversaw, Spearheaded

**Achievement:** Achieved, Exceeded, Surpassed, Accomplished, Attained, Delivered

**Creation:** Developed, Created, Designed, Built, Established, Launched, Initiated

**Improvement:** Improved, Enhanced, Increased, Optimized, Streamlined, Transformed

**Analysis:** Analyzed, Assessed, Evaluated, Identified, Researched, Investigated

**Communication:** Presented, Negotiated, Collaborated, Facilitated, Authored, Trained

### Professional Tone
- Use past tense for previous roles, present for current
- Avoid first-person pronouns (I, me, my)
- Be concise—every word should add value
- Use industry-standard terminology

### Bullet Point Structure
- Start with strong action verb
- Include specific metrics/results
- Keep to 1-2 lines per bullet
- Most important achievements first
- 4-6 bullets for recent positions, 2-3 for older roles

---

## Format Standards

### Length Guidelines
- **0-5 years experience:** One page strongly preferred
- **5-15 years experience:** One to two pages
- **15+ years / Executive:** Two pages acceptable

### Visual Design
- **Margins:** 0.5-1 inch on all sides
- **Font:** Professional sans-serif (Calibri, Arial, Helvetica) or serif (Times New Roman, Garamond)
- **Body text:** 10-12pt
- **Headings:** 14-16pt, bold
- **Line spacing:** 1.0-1.15
- **Alignment:** Left-aligned (centered headers acceptable)

### File Format
- Submit as PDF unless otherwise requested
- Filename: `FirstName_LastName_Resume.pdf`
- Ensure PDF is text-based (not image scan)

---

## Section-Specific Guidance

### Contact Information
**Include:**
- Full name (larger font, bold)
- Phone with professional voicemail
- Professional email (firstname.lastname@provider.com)
- City and State (not full address)
- LinkedIn URL (customized if possible)
- Portfolio/GitHub/website (if relevant)

**Exclude:**
- Date of birth, marital status, photo (US)
- Full street address
- Social Security number

### Professional Summary
**When to Include:**
- Career changers explaining transferable skills
- Experienced professionals highlighting breadth
- When job requirements are very specific

**How to Write:**
- 2-4 sentences maximum
- Lead with years of experience and key expertise
- Include 1-2 notable achievements
- Mirror keywords from target job description

**Example:**
"Marketing professional with 8+ years driving growth for SaaS companies. Expertise in digital strategy, content marketing, and data analytics. Led campaigns that increased MQLs by 150% and contributed to $5M in new revenue."

### Work Experience
**Format:**
```
Job Title | Company Name, City, State
Month Year – Month Year

• Achievement bullet with metrics
• Achievement bullet with metrics
```

**For lesser-known companies:** Add brief 1-sentence description

### Education
**Recent Graduates (0-2 years):**
- Place before experience
- Include GPA if 3.5+
- List relevant coursework (3-5 courses)
- Include honors, awards, scholarships

**Experienced Professionals:**
- Place after experience
- Degree, major, institution, graduation year only
- Omit GPA unless exceptional

### Skills Section
**Technical Skills:**
- Group by category (Languages, Tools, Platforms)
- List in order of proficiency/relevance
- Be honest—you may be tested

**Avoid:**
- Soft skills without context ("excellent communicator")
- Obvious skills ("Microsoft Word" for professional roles)
- Skills rated with bars/stars (subjective)

---

## Common Mistakes

### Content Errors
1. Typos and grammatical errors
2. Inconsistent verb tenses
3. Generic objective statements
4. "Responsible for" instead of achievements
5. Duties without impact
6. Too much personal information

### Format Errors
1. Dense text blocks without white space
2. Inconsistent formatting throughout
3. Unprofessional email address
4. Multiple columns (ATS issues)
5. Text boxes or tables (ATS issues)
6. Decorative fonts or excessive colors

### Strategic Errors
1. Not tailoring to job description
2. Leading with education when experience is stronger
3. Including "References available upon request"
4. Hobbies/interests (unless directly relevant)
5. Including every job ever held

---

## Proofreading Checklist

**Content:**
- [ ] All dates accurate and consistent
- [ ] No typos or grammatical errors
- [ ] Every bullet starts with action verb
- [ ] Achievements include metrics
- [ ] Content relevant to target position
- [ ] Verb tenses consistent

**Format:**
- [ ] Consistent font throughout
- [ ] Uniform bullet style
- [ ] Adequate white space
- [ ] Professional appearance
- [ ] Clear section headers
- [ ] Contact info current

**Final:**
- [ ] Fits appropriate length
- [ ] Opens correctly on different devices
- [ ] All links work
- [ ] Read aloud for awkward phrasing
