# ATS Optimization Guide

Optimize resumes to pass Applicant Tracking System (ATS) screening while remaining readable for humans.

## Table of Contents
1. [How ATS Works](#how-ats-works)
2. [ATS-Friendly Formatting](#ats-friendly-formatting)
3. [Keyword Optimization](#keyword-optimization)
4. [Common ATS Pitfalls](#common-ats-pitfalls)
5. [Testing Your Resume](#testing-your-resume)

---

## How ATS Works

**What ATS Does:**
1. **Parsing:** Extracts data (name, contact, work history, education, skills)
2. **Keyword Matching:** Compares content against job requirements
3. **Ranking:** Scores candidates based on keyword matches
4. **Filtering:** May reject candidates below score thresholds

**Key Insight:** ~75% of resumes never reach human eyes due to ATS filtering.

**Major ATS Platforms:** Workday, Taleo, Greenhouse, Lever, iCIMS, Jobvite, SAP SuccessFactors, BambooHR

---

## ATS-Friendly Formatting

### Do This ✅
- Standard section headings: "Work Experience," "Education," "Skills"
- Left-aligned text
- Simple, single-column layout
- Standard fonts: Arial, Calibri, Helvetica, Times New Roman, Garamond
- Font size: 10-12pt body, 14-16pt headings
- Consistent bullet points (•, -, or — throughout)
- Clear hierarchy with white space
- Standard margins (0.5-1 inch)
- PDF format with selectable text

### Avoid This ❌
- Multiple columns
- Text boxes
- Tables for layout
- Headers/footers with important info
- Images or graphics
- Charts or graphs
- Decorative lines/borders
- Fancy fonts
- Color-coded sections
- Text embedded in images
- Unusual bullet symbols

### Standard Section Headers
**ATS Recognizes:**
- Work Experience / Professional Experience / Employment History
- Education / Academic Background
- Skills / Core Competencies / Technical Skills
- Certifications / Professional Certifications
- Summary / Professional Summary / Profile

**Avoid Creative Headers:**
- "Where I've Been" → Use "Experience"
- "My Toolkit" → Use "Skills"
- "What I Bring" → Use "Summary"

### Date Formatting
**ATS-Friendly Formats:**
- January 2020 – March 2023
- 01/2020 – 03/2023
- Jan 2020 – Mar 2023

**Be Consistent:** Same format throughout entire resume.

---

## Keyword Optimization

### Keyword Types

**Hard Skills:**
- Technical skills (Python, Excel, Salesforce)
- Certifications (PMP, CPA, AWS Certified)
- Industry terminology (GAAP, Agile, CI/CD)
- Methodologies (Six Sigma, Lean, Scrum)

**Job-Specific Keywords:**
- Exact job title variations
- Tools and technologies mentioned
- Required qualifications
- Industry terms

### Keyword Extraction from Job Descriptions

**Step 1: Identify Required Skills**
- Look for "required," "must have," "essential"
- Note years of experience specified
- Identify technical tools mentioned
- Find certifications/degrees required

**Step 2: Note Preferred Skills**
- Look for "preferred," "nice to have," "desired"
- Secondary skills that strengthen candidacy

**Step 3: Extract Action Language**
- Verbs used for responsibilities
- Industry-specific terminology

**Step 4: Use Exact Phrasing**
- If job says "project management," use that phrase
- Match acronyms AND spelled-out versions
- Use both: "JavaScript" AND "JS"

### Strategic Keyword Placement

**Priority Locations:**
1. Professional Summary (3-5 key keywords)
2. Skills Section (all relevant keywords)
3. Work Experience (natural integration)
4. Throughout resume in different contexts

### Natural Integration Examples

**Good Integration:**
"Led cross-functional teams using **Agile methodology** to deliver 15+ software releases, reducing time-to-market by 30%"

**Keyword Stuffing (Avoid):**
"Agile. Cross-functional teams. Software releases. Time-to-market."

### Acronym Strategy
Always include both forms:
- Search Engine Optimization (SEO)
- Certified Public Accountant (CPA)
- Customer Relationship Management (CRM)
- Amazon Web Services (AWS)

---

## Common ATS Pitfalls

### What ATS Cannot Parse

**Graphics/Images:**
- Company logos
- Photos
- Icons for contact info
- Infographics, charts
- Text in images

**Complex Formatting:**
- Columns
- Tables (for layout)
- Text boxes
- Shapes, SmartArt

**Headers/Footers:**
- Contact info in header
- Page numbers
- Document metadata

**Special Characters:**
- Unusual bullets (✓, ➤, ☞)
- Decorative symbols
- Non-standard characters

### Contact Information Format
**ATS-Friendly:**
```
FULL NAME
City, State | Phone | Email | LinkedIn URL
```

**Avoid:**
- Contact info in header/footer
- Icons instead of text (📧, 📱)
- Hyperlinked text without showing URL

---

## Testing Your Resume

### Pre-Submission Checks

**1. Plain Text Test:**
- Copy resume into Notepad
- Check if all info is readable
- If garbled, ATS will have issues

**2. PDF Text Selection:**
- Open PDF and try to select/copy text
- If you can't select text, it's an image (will fail ATS)

**3. File Naming:**
- Use: `FirstName_LastName_Resume.pdf`
- Avoid: `resume.pdf`, `My_Resume_FINAL_v2.pdf`

### Keyword Coverage Check

Before submitting, verify:
- [ ] All major job requirements appear in resume
- [ ] Keywords appear multiple times (naturally)
- [ ] Both acronyms and spelled-out versions included
- [ ] Job title variations covered

---

## Industry-Specific Keywords

### Technology/Engineering
- Programming languages, frameworks, tools
- Methodologies: Agile, DevOps, CI/CD
- Certifications: AWS, Azure, Google Cloud
- Specific technologies from job posting

### Marketing/Sales
- Digital marketing platforms
- CRM systems (Salesforce, HubSpot)
- Channels: SEO, SEM, social media
- Metrics: conversion rates, ROI, CAC, LTV

### Finance/Accounting
- Certifications: CPA, CFA, CMA
- Software: QuickBooks, SAP, Oracle
- Terminology: GAAP, reconciliation, audit
- Regulatory: SOX, IFRS

### Healthcare
- Licenses and certifications
- Medical terminology
- Software: Epic, Cerner
- Procedures and specialties

---

## Customization Strategy

### For Each Application:

1. **Analyze Job Description**
   - Highlight all keywords
   - Note technical terms
   - Identify required vs. preferred

2. **Update Skills Section**
   - Lead with most relevant skills
   - Use exact phrasing from job description
   - Include both acronyms and full names

3. **Revise Summary**
   - Mirror language from job description
   - Include top required qualifications
   - Use job title if applicable

4. **Adjust Experience**
   - Reorder bullets for relevance
   - Integrate keywords naturally
   - Lead with matching achievements

---

## Balance: ATS vs. Human Readers

**Optimize for Both:**
- Use keywords naturally, not in lists
- Maintain compelling narratives
- Quantify achievements
- Tell coherent career story
- Ensure visual appeal once parsed

**The Goal:**
Pass ATS screening while creating a resume that impresses human recruiters. Well-optimized resumes serve both audiences.

**Final Check:**
- ✅ Can ATS parse it?
- ✅ Would a human enjoy reading it?
- ✅ Does it showcase qualifications compellingly?
