"""
配置文件 — 城市代码、匹配参数、评分权重、CSS 选择器
基于原始 config.py 扩展，增加了实际运行所需的配置
"""
import os

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  大众点评城市代码
#  新增城市：打开 dianping.com 切换城市，URL 里 /keyword/X/ 的 X 就是代码
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
CITY_CODES = {
    "上海": 1,  "北京": 2,  "天津": 3,  "广州": 4,  "杭州": 5,
    "南京": 6,  "深圳": 7,  "成都": 8,  "重庆": 9,  "武汉": 10,
    "苏州": 11, "长沙": 12, "厦门": 15, "沈阳": 16, "西安": 17,
    "青岛": 18, "大连": 19, "济南": 20, "哈尔滨": 22, "昆明": 23,
    "郑州": 27, "福州": 28, "宁波": 29, "无锡": 30, "合肥": 31,
    "温州": 46, "东莞": 119, "佛山": 125, "珠海": 126,
}

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  会话路径
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
SESSION_BASE = os.path.expanduser("~/.local/share/restaurant-crosscheck/sessions")
DIANPING_SESSION = os.path.join(SESSION_BASE, "dianping")
XHS_SESSION = os.path.join(SESSION_BASE, "xiaohongshu")

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  搜索与匹配参数（来自原始 config.py）
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
DEFAULT_THRESHOLDS = {
    "min_rating": 4.0,
    "min_dianping_reviews": 50,
    "min_xhs_notes": 1,           # 原始是 20，实际抓取很难达到，改为 1
    "max_results": 15,
    "similarity_threshold": 0.55,  # 模糊匹配阈值
}

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  评分权重（来自原始 config.py）
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
SCORING_WEIGHTS = {
    "dianping_rating": 0.4,
    "xhs_engagement": 0.3,
    "consistency": 0.3,
}

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  输出配置
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
OUTPUT_CONFIG = {
    "max_restaurants": 10,
    "show_details": True,
    "confidence_threshold": 0.5,
}

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  浏览器 / 抓取参数
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
BROWSER_ARGS = ['--disable-blink-features=AutomationControlled']
PAGE_LOAD_WAIT = 4        # 页面加载等待秒数
SCROLL_WAIT = 1.5         # 滚动等待秒数
MAX_DIANPING_ITEMS = 15   # 大众点评最多抓几家
MAX_XHS_NOTES = 25        # 小红书最多看几篇笔记

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  大众点评 CSS 选择器（按优先级）
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
DP_LIST_SELECTORS = [
    '.shop-list ul li',
    '#shop-all-list li',
    'div[data-shopid]',
    '.shoplist li',
    '.shop-wrap',
]
DP_NAME_SELECTORS = ['.tit', '.shop-name', 'h4', '.shopname', 'b', 'a[href*="/shop/"] span']
DP_SCORE_SELECTORS = ['[class*="star"]', '[class*="score"]', '.star', '.score']
DP_REVIEW_SELECTORS = ['.review-num', '.comment-num', '[class*="review"]', '[class*="comment"]']
DP_PRICE_SELECTORS = ['.mean-price', '[class*="price"]', '.avgprice']
DP_ADDR_SELECTORS = ['.addr', '[class*="addr"]', '.area']
DP_TAG_SELECTORS = ['.shop-tag', '[class*="tag"]', '.svc-tag']

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  小红书 CSS 选择器
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
XHS_CARD_SELECTORS = [
    '[class*="note-item"]',
    'section[class*="note"]',
    'a[href*="/explore/"]',
    'a[href*="/search_result/"]',
]

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  情感分析词典（扩展版）
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
POSITIVE_WORDS = [
    '好吃', '推荐', '超赞', '必吃', '绝了', '惊艳', '正宗', '地道',
    '超棒', '性价比高', '回头客', '排队', '宝藏', '天花板', 'yyds',
    '强推', '五星', '满分', '神仙', '顶级', '美味', '值得', '完美',
]
NEGATIVE_WORDS = [
    '难吃', '不好吃', '踩雷', '避雷', '不推荐', '失望', '差评',
    '不值', '翻车', '不会再去', '一般', '过誉', '差',
]
NEGATION_WORDS = ['不', '没', '别', '非', '无', '未']

# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
#  店名提取
# ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
SHOP_SUFFIXES = [
    '店', '餐厅', '饭店', '酒楼', '食府', '菜馆', '面馆', '烧烤',
    '火锅', '寿司', '拉面', '小馆', '私房', '酒家', '茶楼', '茶餐厅',
    '大排档', '小厨', '食堂', '饭堂', '咖啡', '甜品', '烘焙', '会所',
    '工作室', '馆', '餐馆', '料理', '烤肉', '串串', '披萨', '汉堡',
]
EXCLUDE_KEYWORDS = [
    '推荐', '攻略', '必吃', '探店', '打卡', '合集', '分享',
    '测评', '避坑', '指南', '盘点', '安利', '种草',
]
