# Responsive Design

Modern responsive CSS patterns using container queries, fluid typography, CSS Grid, and mobile-first strategies.

## What's Inside

- Mobile-first breakpoint scale
- Container queries (CSS and Tailwind)
- Fluid typography with `clamp()` and CSS custom properties
- Fluid spacing scale
- CSS Grid responsive layouts (auto-fit, named areas)
- Responsive navigation patterns
- Responsive images (art direction, resolution switching)
- Responsive tables (horizontal scroll, card layout on mobile)
- Viewport units (dvh, svh, lvh)
- Common issues and fixes

## When to Use

- Building layouts that adapt across screen sizes
- Creating reusable components that respond to container size
- Implementing fluid typography scales
- Setting up responsive grid systems
- Handling mobile navigation patterns
- Optimizing images for different devices

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/frontend/responsive-design
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install responsive-design
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/frontend/responsive-design .cursor/skills/responsive-design
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/frontend/responsive-design ~/.cursor/skills/responsive-design
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/frontend/responsive-design .claude/skills/responsive-design
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/frontend/responsive-design ~/.claude/skills/responsive-design
```

---

Part of the [Frontend](..) skill category.
