# Shared Prompt Blocks

These blocks appear verbatim in all three research sub-agent prompts.
Edit here and apply consistently to breadth.md, critical.md, and evidence.md.

---

## Block: provided-sources

```
### Provided sources

Check whether the following file exists in the workspace:
  {{WORKSPACE_PATH}}/sources-provided-{{TOPIC_SLUG}}-{{DATE}}.md

If the file exists, read it in full before conducting any web research.
Every source listed in it is a mandatory input — read each one and engage
with it through your analytical role. These sources are starting points
and reference material that your independent research must contextualise,
corroborate, challenge, or extend. Apply the same critical scrutiny to them
as to any source you discover yourself.

If the file does not exist, proceed with open research only.
```

---

## Block: ai-provenance

```
### AI provenance

For every source you read — whether provided or discovered — actively look
for indicators that it was produced by an AI:

- Explicit disclosure statements: phrases such as "generated by", "produced
  using", or model names in headers, footers, or methodology sections
- Model ID strings (e.g. claude-sonnet-4-6, gpt-4o, gemini-2.5-pro) — record
  these when present; they enable downstream lookup of that model's knowledge
  cutoff and documented limitations
- Stylistic signals: uniform structure throughout, hedged language patterns,
  absence of genuine uncertainty, implausibly comprehensive coverage
- Self-referential disclosure: outputs from this skill explicitly state AI
  authorship and list model IDs — treat such documents as AI-generated and
  record the listed model IDs

Record AI provenance in your SOURCES section alongside access status.
AI provenance is metadata that informs how to weight a source — it is not
a reason to exclude it.
```

---

## Block: source-extracts

```
### Source extracts

Save source extracts: {{SAVE_SOURCE_EXTRACTS}}

If Save source extracts is true:
For every source in your SOURCES section, write a cleaned extract to:
  {{WORKSPACE_PATH}}/sources/{{TOPIC_SLUG}}-{{DATE}}/[SOURCE_SLUG].md

Where [SOURCE_SLUG] is a short lowercase-hyphenated identifier
(e.g. leibowitz-2021-chromothripsis, igi-2025-clinical-trials).

Each extract must contain:
- Source metadata: author, year, title, URL, access status, AI provenance
- Only the content you actually used — not the full fetched page
- One sentence stating which claims in your report this source supports

Do not write extracts for sources you touched but did not cite.
Do not write raw HTML or full page content.

If Save source extracts is false, skip this step entirely.
```

---

## Block: full-text-retrieval (standard)

```
### Full-text retrieval

Read every substantive source in full — do not rely on search snippets.
Follow this sequence for every source:

1. Run web searches to identify sources. Use at least 3 distinct queries
   covering different facets of the topic.
2. Use web_fetch (extractMode="markdown") to retrieve the full text of every substantive source. This is your primary retrieval tool.
3. If the URL resolves to a PDF, use your PDF tool to extract the full text.
   Do not skip a source because it is a PDF.
4. If web_fetch returns thin or blocked content, use the browser tool.
   **Warning:** Browser automation is resource-intensive and can be fragile.
   Only use `browser` if `web_fetch` explicitly fails (e.g. 403/401) or returns unusable content. 
   Prefer `web_fetch` for stability whenever possible.
5. If a source is paywalled, search for an open-access version on the
   author's institutional page, a preprint server, or a repository before
   recording it as inaccessible.
6. Record access status for every source:
   full text | abstract only | snippet only | paywalled after alternatives tried
```

---

## Block: sources-section

```
### SOURCES section

At the end of your report, write a SOURCES section listing every source
you touched. Use this format for each entry:

[Author/Org] | [Year] | [Title] | [URL] | [Access] | [AI-generated: yes/no/unknown — model ID if known]

List every source. If you touched twenty sources, list twenty.
Flag any source you could not verify: append [UNVERIFIED].

After the pipe-delimited list, write a BibTeX block containing one entry
per source. Use standard BibTeX fields. Put access status and AI provenance
in the note = {} field. Example:

@article{leibowitz2021chromothripsis,
  author  = {Leibowitz, Mitchell L. and others},
  year    = {2021},
  title   = {Chromothripsis as an on-target consequence of CRISPR-Cas9 genome editing},
  journal = {Nature Genetics},
  url     = {https://doi.org/10.1038/s41588-021-00838-7},
  note    = {Access: full text. AI-generated: no.}
}

Use @article for journal papers, @techreport for reports, @misc for web
pages and sources without a clear type. The BibTeX block is used for
import into reference managers — accuracy of field values matters.
```
