---
name: research-logger
version: 1.0.0
description: >
  Auto-saves deep search results to SQLite and Langfuse. Combines search with persistent
  logging — every research query is saved with topic tags, timestamps, and full results.
  Search past research, view recent entries. Triggers: log research, save search,
  research history, find past research, what did I research.
license: MIT
compatibility:
  openclaw: ">=0.10"
metadata:
  openclaw:
    requires:
      bins: ["python3"]
      env: ["PERPLEXITY_API_KEY"]
---

# Research Logger 📝🔬

Search + auto-save pipeline. Every research query is logged to SQLite with Langfuse tracing.

## When to Use

- Research that you want to save and recall later
- Building a knowledge base from repeated searches
- Reviewing past research on a topic
- Creating an audit trail of research decisions

## Usage

```bash
# Search and auto-log
python3 {baseDir}/scripts/research_logger.py log quick "what is RAG"
python3 {baseDir}/scripts/research_logger.py log pro "compare vector databases" --topic "databases"

# Search past research
python3 {baseDir}/scripts/research_logger.py search "vector databases"

# View recent entries
python3 {baseDir}/scripts/research_logger.py recent --limit 5
```

## Credits

Built by [M. Abidi](https://www.linkedin.com/in/mohammad-ali-abidi) | [agxntsix.ai](https://www.agxntsix.ai)
[YouTube](https://youtube.com/@aiwithabidi) | [GitHub](https://github.com/aiwithabidi)
Part of the **AgxntSix Skill Suite** for OpenClaw agents.

📅 **Need help setting up OpenClaw for your business?** [Book a free consultation](https://cal.com/agxntsix/abidi-openclaw)
