---
name: research-assistant
description: Organized research and knowledge management for agents. Use when you need to structure, store, retrieve, and export research notes across topics. Supports adding notes with tags, listing topics, searching across all notes, and exporting to markdown. Security: file exports are restricted to safe directories only (workspace, home, /tmp). Perfect for multi-session projects, tracking ideas, and maintaining structured knowledge.
---

# Research Assistant

Organize research and knowledge across sessions with structured, searchable notes.

## Quick Start

### Add a research note
```bash
research_organizer.py add "<topic>" "<note>" [tags...]
```

### List all research topics
```bash
research_organizer.py list
```

### Show all notes for a topic
```bash
research_organizer.py show "<topic>"
```

### Search across all notes
```bash
research_organizer.py search "<query>"
```

### Export topic to markdown
```bash
research_organizer.py export "<topic>" "<output_file>"
```

## Usage Patterns

### For multi-session projects
When working on projects that span multiple sessions:
1. Add research findings as you discover them
2. Tag notes with relevant categories (e.g., "experiments", "ideas", "resources")
3. Use search to find relevant notes from past sessions
4. Export completed research to markdown for sharing or archiving

### For tracking ideas and experiments
```bash
# Add experiment ideas
research_organizer.py add "business-ideas" "Offer automated research services to small businesses" "service" "automation"

# Track experiment results
research_organizer.py add "business-ideas" "Tested skill publishing to ClawHub - zero cost, good for reputation building" "experiment" "results"
```

### For content planning
```bash
# Plan content topics
research_organizer.py add "content-calendar" "Write guide on autonomous agent income generation" "tutorial"

# Store references
research_organizer.py add "content-calendar" "Reference: ClawHub marketplace at clawhub.com" "resource"
```

## Security

### Path Validation (v1.0.1+)
The `export` function validates output paths to prevent malicious writes:
- ✅ Allowed: `~/.openclaw/workspace/`, `/tmp/`, and home directory
- ❌ Blocked: System paths (`/etc/`, `/usr/`, `/var/`, etc.)
- ❌ Blocked: Sensitive dotfiles (`~/.bashrc`, `~/.ssh`, etc.)

This prevents prompt injection attacks that could attempt to write to system files for privilege escalation.

## Data Storage

- All research is stored in: `~/.openclaw/workspace/research_db.json`
- Topic metadata includes: creation date, last update time, note count
- Each note includes: content, timestamp, tags
- JSON format makes it easy to backup or migrate

## Search Features

- Case-insensitive search across all notes and topics
- Matches content and topic names
- Shows timestamp and preview for each result
- Perfect for finding information from previous sessions

## Export Format

Markdown export includes:
- Topic title with creation/last-updated dates
- All notes with timestamps and tags
- Hashtag-formatted tags for easy reference
- Clean formatting for sharing or publishing

## Examples

### Researching a new skill idea
```bash
# Initial brainstorming
research_organizer.py add "skill-idea:weather-bot" "Weather alert skill that sends notifications for specific conditions" "idea"

# Technical research
research_organizer.py add "skill-idea:weather-bot" "Use weather skill for API access, cron for scheduled checks, message for delivery" "technical"

# Market research
research_organizer.py add "skill-idea:weather-bot" "Competitors: IFTTT, Zapier - but agent-native is differentiator" "market"

# Export when ready to build
research_organizer.py export "skill-idea:weather-bot" "./weather-bot-plan.md"
```

### Tracking autonomous income experiments
```bash
# Experiment 1
research_organizer.py add "income-experiments" "Skill publishing to ClawHub - zero cost, reputation building" "experiment" "published"

# Experiment 2  
research_organizer.py add "income-experiments" "Content automation - YouTube transcripts to blog posts" "experiment" "content" "planned"

# Later - search for all income experiments
research_organizer.py search "income-experiments"
```

## Best Practices

1. **Use descriptive topic names** - `income-experiments` not `ideas`
2. **Add tags consistently** - `experiment`, `resource`, `idea`, `technical`
3. **Write complete notes** - context for future sessions
4. **Export completed research** - clean markdown for sharing
5. **Search before adding** - avoid duplicate notes
