---
name: rescuetime
description: Fetch productivity data from RescueTime. Use when the user asks about their screen time, productivity score, app usage, time tracking, how they spent their day/week, or wants reports on their computer activity. Requires API key in TOOLS.md or passed directly.
---

# RescueTime

Fetch productivity analytics from the RescueTime API.

## Setup

Store API key in TOOLS.md:

```markdown
### RescueTime
- API Key: YOUR_KEY_HERE
```

Get a key at: https://www.rescuetime.com/anapi/manage

## API Endpoints

### Analytic Data (main endpoint)

```bash
curl "https://www.rescuetime.com/anapi/data?key=API_KEY&format=json&perspective=rank&restrict_kind=activity"
```

Parameters:
- `perspective`: rank, interval, member
- `restrict_kind`: category, activity, productivity, efficiency, document
- `interval`: month, week, day, hour (only for interval perspective)
- `restrict_begin` / `restrict_end`: YYYY-MM-DD
- `restrict_thing`: filter to specific app/site/category

### Daily Summary Feed

```bash
curl "https://www.rescuetime.com/anapi/daily_summary_feed?key=API_KEY"
```

Returns last 14 days with productivity_pulse (0-100), total_hours, categories.

## Productivity Levels

- 2: Very Productive (coding, writing, Terminal, IDEs)
- 1: Productive (communication, reference, learning)
- 0: Neutral (uncategorized)
- -1: Distracting (news, shopping)
- -2: Very Distracting (social media, games)

## Common Queries

**Today's activity by app:**
```bash
curl "https://www.rescuetime.com/anapi/data?key=API_KEY&format=json&perspective=rank&restrict_kind=activity&restrict_begin=$(date +%Y-%m-%d)&restrict_end=$(date +%Y-%m-%d)"
```

**Productivity breakdown:**
```bash
curl "https://www.rescuetime.com/anapi/data?key=API_KEY&format=json&perspective=rank&restrict_kind=productivity"
```

**By category:**
```bash
curl "https://www.rescuetime.com/anapi/data?key=API_KEY&format=json&perspective=rank&restrict_kind=category"
```

**Hourly breakdown today:**
```bash
curl "https://www.rescuetime.com/anapi/data?key=API_KEY&format=json&perspective=interval&restrict_kind=productivity&interval=hour&restrict_begin=$(date +%Y-%m-%d)&restrict_end=$(date +%Y-%m-%d)"
```

## Response Format

```json
{
  "row_headers": ["Rank", "Time Spent (seconds)", "Number of People", "Activity", "Category", "Productivity"],
  "rows": [[1, 3600, 1, "VS Code", "Editing & IDEs", 2], ...]
}
```

Convert seconds to hours: `seconds / 3600`

## Tips

- Productivity pulse 75+ is good, 85+ is excellent
- Category view helps see broad patterns
- Use interval perspective with hour for time-of-day analysis
- Data syncs every 3 min (premium) or 30 min (free)
