# 优先级排序方法详解

## 方法 1：MoSCoW 优先级排序

### 分类
- **必须有（Must Have）**：发布的关键功能，不可协商
- **应该有（Should Have）**：重要但不关键，必要时可以推迟
- **可以有（Could Have）**：最好有，时间允许时包含
- **不会有（Won't Have）**：本次发布不在范围内

### 流程
1. 列出所有需求
2. 对每个需求进行分类
3. 在每个类别内按重要性排序
4. 与利益相关者验证

### 示例
```
必须有：
1. 使用邮箱/密码的用户登录
2. 密码重置功能
3. 基本用户资料

应该有：
1. 社交登录（Google、Facebook）
2. 双因素认证
3. 头像上传

可以有：
1. 使用手机号登录
2. 生物识别认证
3. 活动日志

不会有（本次发布）：
1. 单点登录（SSO）
2. LDAP 集成
3. OAuth 提供商
```

---

## 方法 2：RICE 评分

### 公式
RICE = (覆盖面 × 影响力 × 信心度) / 工作量

### 组成部分
- **覆盖面（Reach）**：这将影响多少用户？（每季度）
- **影响力（Impact）**：对每个用户的影响有多大？
  - 3 = 巨大
  - 2 = 高
  - 1 = 中
  - 0.5 = 低
  - 0.25 = 最小
- **信心度（Confidence）**：我们对估算有多自信？
  - 100% = 高
  - 80% = 中
  - 50% = 低
- **工作量（Effort）**：这需要多少人月？

### 流程
1. 对每个需求在所有四个维度上评分
2. 计算 RICE 分数
3. 按 RICE 分数排序需求（最高优先）

### 示例
```
需求 1：用户登录
- 覆盖面：10,000 用户/季度
- 影响力：3（巨大）
- 信心度：100%
- 工作量：2 人月
- RICE 分数：(10,000 × 3 × 1.0) / 2 = 15,000

需求 2：社交登录
- 覆盖面：5,000 用户/季度
- 影响力：2（高）
- 信心度：80%
- 工作量：1 人月
- RICE 分数：(5,000 × 2 × 0.8) / 1 = 8,000

需求 3：双因素认证
- 覆盖面：10,000 用户/季度
- 影响力：2（高）
- 信心度：90%
- 工作量：1.5 人月
- RICE 分数：(10,000 × 2 × 0.9) / 1.5 = 12,000

优先级顺序：需求 1 > 需求 3 > 需求 2
```

---

## 方法 3：价值 vs 成本矩阵

### 象限
- **快速胜利（Quick Wins）**（高价值，低成本）：首先做
- **重大项目（Major Projects）**（高价值，高成本）：其次做
- **填充项（Fill-Ins）**（低价值，低成本）：时间允许时做
- **时间陷阱（Time Sinks）**（低价值，高成本）：避免或推迟

### 流程
1. 对每个需求的价值评分（1-10）
2. 对每个需求的成本评分（1-10）
3. 在 2×2 矩阵上绘制
4. 优先处理快速胜利，然后是重大项目

### 示例矩阵
```
高价值
    │
    │  重大项目            快速胜利
    │  - SSO 集成         - 密码重置
    │  - OAuth 提供商     - 资料编辑
    │                      - 邮箱验证
────┼────────────────────────────────────
    │  时间陷阱            填充项
    │  - LDAP 集成        - 活动日志
    │  - 自定义认证        - 登录历史
    │
低价值
    低成本 ──────────────── 高成本
```

---

## 方法 4：Kano 模型

### 分类
- **基本型需求（Basic Needs）**：必须有，用户期望它们（缺少会不满）
- **期望型需求（Performance Needs）**：越多越好（满意度线性增加）
- **兴奋型需求（Excitement Needs）**：意外的惊喜（存在时高满意度）
- **无差异（Indifferent）**：用户不在乎
- **反向（Reverse）**：用户更喜欢没有这个功能

### 流程
1. 通过功能性和非功能性问题调查用户
2. 对每个功能进行分类
3. 优先级：基本型需求 → 期望型需求 → 兴奋型需求

### 示例
```
基本型需求（必须有）：
- 用户登录
- 密码安全
- 账户恢复

期望型需求（应该有）：
- 快速登录（< 2 秒）
- 多种登录选项
- 会话管理

兴奋型需求（可以有）：
- 生物识别登录
- 无密码认证
- 社交登录

无差异：
- 登录自定义主题
```

---

## 方法 5：加权评分

### 流程
1. 定义评估标准（例如：业务价值、技术可行性、用户影响、战略一致性）
2. 为每个标准分配权重（总计 = 100%）
3. 对每个需求在每个标准上评分（1-10）
4. 计算加权分数
5. 按加权分数排序

### 示例
```
标准权重：
- 业务价值：40%
- 用户影响：30%
- 技术可行性：20%
- 战略一致性：10%

需求 1：用户登录
- 业务价值：10 × 0.4 = 4.0
- 用户影响：10 × 0.3 = 3.0
- 技术可行性：8 × 0.2 = 1.6
- 战略一致性：9 × 0.1 = 0.9
- 总分：9.5

需求 2：社交登录
- 业务价值：7 × 0.4 = 2.8
- 用户影响：8 × 0.3 = 2.4
- 技术可行性：6 × 0.2 = 1.2
- 战略一致性：7 × 0.1 = 0.7
- 总分：7.1

优先级顺序：需求 1 > 需求 2
```

---

## 方法选择指南

| 方法 | 最适合 | 优点 | 缺点 |
|--------|----------|------|------|
| **MoSCoW** | 简单优先级，明确必需项 | 易于理解，快速 | 主观，无量化评分 |
| **RICE** | 数据驱动决策，多需求 | 客观，考虑多因素 | 需要估算，耗时 |
| **价值 vs 成本** | 可视化优先级，快速决策 | 简单，可视化，快速 | 过于简化，只有 2 个维度 |
| **Kano 模型** | 关注用户满意度 | 以用户为中心，识别惊喜点 | 需要用户研究，复杂 |
| **加权评分** | 自定义标准，利益相关者对齐 | 灵活，透明 | 需要权重共识 |
