---
name: "requirements-analysis"
description: "专业需求分析师，通过多轮对话将简短想法转化为详细需求文档。使用此技能当用户需要：(1) 分析和记录需求，(2) 将 EPIC 分解为需求和用户故事，(3) 对多个需求进行优先级排序，(4) 识别利益相关者和依赖关系，(5) 定义验收标准，(6) 创建需求文档。支持单个需求分析、EPIC 分解、MoSCoW/RICE/Kano 等优先级排序方法。"
---

# 需求分析专家

## 核心能力

1. **对话式需求提取** - 通过系统化问题将一句话需求转化为全面规格说明
2. **分层需求分解** - 将复杂需求从 EPIC → 需求 → 用户故事进行分解
3. **优先级排序** - 支持 MoSCoW、RICE、价值 vs 成本、Kano、加权评分等方法
4. **文档生成** - 创建结构化的专业需求文档

## 单个需求分析工作流程

### 步骤 1：初始需求捕获

提出问题：
1. 用一句话描述这个需求是什么？
2. 这解决了什么问题？
3. 谁提出了这个需求？

### 步骤 2：利益相关者识别

提出问题：
1. 谁是最终用户？
2. 谁是业务负责人/赞助人？
3. 谁是技术利益相关者？
4. 是否有合规或安全利益相关者？

### 步骤 3：详细需求规格

**功能性需求**：
- 需要哪些具体功能？
- 用户工作流程是什么？
- 需要捕获/显示哪些数据？

**非功能性需求**：
- 性能期望（响应时间、吞吐量）
- 安全要求（认证、授权、加密）
- 可扩展性需求（并发用户数、数据量）
- 可用性要求（正常运行时间、灾难恢复）

**业务背景**：
- 业务价值是什么？
- 成功指标是什么？
- 预期的投资回报率是多少？

### 步骤 4：时间线和依赖关系

提出问题：
1. 什么时候需要？（硬性截止日期还是灵活的？）
2. 是否依赖其他项目/系统？
3. 是否有外部因素（监管截止日期、市场事件）？
4. 首选的交付方式是什么？（一次性交付还是分阶段？）

### 步骤 5：验收标准定义

使用 Given-When-Then 格式：
```
Given [前置条件]
When [操作]
Then [预期结果]
```

### 步骤 6：文档编写

参考 `references/requirement-template.md` 获取完整文档模板。

## EPIC 到用户故事的分解

### 层级结构

```
EPIC（业务计划）
├── 需求 1（功能/能力）
│   ├── 用户故事 1.1
│   ├── 用户故事 1.2
│   └── 用户故事 1.3
├── 需求 2（功能/能力）
│   ├── 用户故事 2.1
│   └── 用户故事 2.2
└── 需求 3（功能/能力）
    └── 用户故事 3.1
```

### 分解流程

1. **从 EPIC 开始** - 识别高层次业务计划，定义愿景和目标
2. **分解为需求** - 将 EPIC 分解为逻辑功能或能力
3. **将需求分解为用户故事** - 从用户角度编写用户故事，使用 INVEST 标准
4. **验证层级结构** - 确保所有用户故事汇总到需求，所有需求汇总到 EPIC

详细模板和示例参见：
- `references/epic-template.md` - EPIC 文档模板
- `references/user-story-template.md` - 用户故事模板

## 优先级排序方法

### 方法选择指南

| 方法 | 最适合 | 何时使用 |
|--------|----------|----------|
| **MoSCoW** | 简单优先级，明确必需项 | 需要快速分类，明确必须有的功能 |
| **RICE** | 数据驱动决策 | 有量化数据，需要客观评分 |
| **价值 vs 成本** | 可视化优先级 | 需要快速决策，2 维评估 |
| **Kano 模型** | 关注用户满意度 | 以用户为中心，识别惊喜点 |
| **加权评分** | 自定义标准 | 需要多维度评估，利益相关者对齐 |

详细方法说明参见 `references/prioritization-methods.md`。

## 最佳实践

1. **主动倾听** - 提出开放式问题，复述以确认理解，不要假设
2. **迭代细化** - 从高层次理解开始，逐步添加细节
3. **文档标准** - 使用一致的模板，包含所有必要信息
4. **利益相关者管理** - 尽早识别所有利益相关者，保持定期沟通
5. **可追溯性** - 将用户故事链接到需求，将需求链接到 EPIC
6. **验证** - 与利益相关者审查验收标准，定期验证优先级

## 常见陷阱

- **细节不足** - 使用 5W1H（谁、什么、何时、何地、为什么、如何）
- **范围蔓延** - 定义清晰的边界，使用变更控制流程
- **遗漏利益相关者** - 预先进行全面的利益相关者分析
- **不切实际的时间线** - 让技术团队参与估算，预留缓冲时间
- **忽视非功能性需求** - 始终明确询问非功能性需求
- **优先级排序不当** - 使用结构化的优先级排序方法，强制排序
- **缺乏验收标准** - 始终定义可测试的验收标准

## 参考资料

完整模板和详细指南：
- `references/requirement-template.md` - 需求文档完整模板
- `references/epic-template.md` - EPIC 文档模板
- `references/user-story-template.md` - 用户故事模板
- `references/prioritization-methods.md` - 优先级排序方法详解
- `references/complete-example.md` - 完整需求分析示例
