# 需求评估标准

## 一、需求澄清维度

### 1. 客户背景
- **新客户 vs 老客户**：老客户需确认是否有历史系统、技术栈、业务约束
- **行业属性**：ToB/ToC、行业规范、合规要求
- **项目规模**：小型 (<1 人月)、中型 (1-3 人月)、大型 (>3 人月)

### 2. 系统现状
- **全新开发**：从零开始，无历史包袱
- **部分实现**：需确认已有功能模块、技术栈、代码质量
- **改造升级**：需评估兼容性、迁移成本、风险评估

### 3. 需求类型
- **功能需求**：具体业务功能
- **非功能需求**：性能、安全、可用性、可扩展性
- **集成需求**：第三方系统对接、API 调用

---

## 二、需求合理性评估维度

### 1. 技术可行性
| 评估项 | 说明 |
|--------|------|
| 技术成熟度 | 是否有成熟方案/开源库 |
| 技术栈匹配 | 与现有技术栈是否一致 |
| 第三方依赖 | 是否有不可控的外部依赖 |

### 2. 业务合理性
| 评估项 | 说明 |
|--------|------|
| 用户价值 | 是否解决真实痛点 |
| 使用频率 | 高频/低频功能 |
| 业务闭环 | 是否形成完整业务流程 |

### 3. 成本效益
| 评估项 | 说明 |
|--------|------|
| 投入产出比 | 开发成本 vs 预期收益 |
| 替代方案 | 是否有更低成本的实现方式 |
| 优先级 | 核心功能 vs 锦上添花 |

---

## 三、工时评估基准（人·天）

### 产品岗位
| 功能复杂度 | 工时范围 | 说明 |
|------------|----------|------|
| 简单需求 | 0.5-1 | 单页面、逻辑简单 |
| 中等需求 | 1-3 | 多页面、有一定业务逻辑 |
| 复杂需求 | 3-5 | 跨模块、复杂业务流程 |

### UI 设计
| 设计类型 | 工时范围 | 说明 |
|----------|----------|------|
| 简单页面 | 0.5-1 | 标准组件、无特殊设计 |
| 中等页面 | 1-2 | 定制组件、有一定设计感 |
| 复杂页面 | 2-4 | 动效、特殊交互、多状态 |
| 设计规范 | 2-5 | 完整设计系统/组件库 |

### 前端开发
| 功能类型 | 工时范围 | 说明 |
|----------|----------|------|
| 静态页面 | 0.5-1 | 纯展示、无交互 |
| 表单交互 | 1-2 | 表单、验证、提交 |
| 数据展示 | 1-3 | 列表、表格、图表 |
| 复杂交互 | 3-5 | 拖拽、动画、实时通信 |
| 页面集成 | 0.5-1 | 路由、状态管理 |

### 后端开发
| 功能类型 | 工时范围 | 说明 |
|----------|----------|------|
| 简单 API | 0.5-1 | CRUD、单表操作 |
| 中等 API | 1-2 | 多表关联、业务逻辑 |
| 复杂 API | 2-4 | 事务、并发、复杂计算 |
| 第三方集成 | 1-3 | 对接外部 API/服务 |
| 数据处理 | 1-3 | 批量处理、数据迁移 |

### 测试
| 测试类型 | 工时比例 | 说明 |
|----------|----------|------|
| 功能测试 | 开发工时的 20-30% | 用例编写 + 执行 |
| 回归测试 | 开发工时的 10-15% | 已有功能验证 |
| 性能测试 | 1-3 人天 | 压测、优化建议 |
| 安全测试 | 1-2 人天 | 漏洞扫描、渗透测试 |

### 运维
| 工作类型 | 工时范围 | 说明 |
|----------|----------|------|
| 环境搭建 | 0.5-2 | 开发/测试/生产环境 |
| 部署配置 | 0.5-1 | CI/CD、发布流程 |
| 监控配置 | 0.5-1 | 日志、告警、监控面板 |

### 移动端（iOS/Android/鸿蒙）
| 功能类型 | 工时范围 | 说明 |
|----------|----------|------|
| 简单页面 | 1-2 | 展示、基础交互 |
| 中等功能 | 2-4 | API 调用、本地存储 |
| 复杂功能 | 4-8 | 原生能力、性能优化 |
| 多端适配 | +30% | 不同屏幕、系统版本 |

---

## 四、AI 辅助工时折算

在 AI 辅助下，以下岗位工时可进行折算：

| 岗位 | AI 辅助场景 | 折算系数 |
|------|------------|----------|
| 产品 | 文档生成、竞品分析 | 0.6-0.7 |
| UI | 初稿生成、素材处理 | 0.7-0.8 |
| 前端 | 代码生成、组件搭建 | 0.5-0.7 |
| 后端 | 代码生成、API  scaffold | 0.5-0.7 |
| 测试 | 用例生成、自动化脚本 | 0.6-0.8 |
| 运维 | 脚本生成、配置模板 | 0.7-0.8 |
| 移动端 | 代码生成、UI 搭建 | 0.6-0.8 |

**注意**：折算后的工时需考虑 AI 输出审核、修改、调试的时间。

---

## 五、风险评估清单

- [ ] 需求是否清晰、无歧义
- [ ] 技术可行性是否已验证
- [ ] 是否有第三方依赖风险
- [ ] 是否有性能瓶颈风险
- [ ] 是否有安全合规风险
- [ ] 是否有人员技能匹配风险
- [ ] 是否有工期紧张风险
- [ ] 是否有需求变更风险
