# 常见功能模块参考

## 一、通用子系统

### 1. 用户系统
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 注册登录 | 手机号/邮箱注册、密码登录、验证码 | 中 |
| 第三方登录 | 微信、支付宝、Google、Apple 登录 | 中 |
| 个人中心 | 基本信息、头像、密码修改 | 低 |
| 权限管理 | 角色、权限、菜单控制 | 高 |
| 登录日志 | 登录记录、设备管理 | 低 |

### 2. 内容管理 (CMS)
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 文章管理 | 发布、编辑、删除、分类、标签 | 中 |
| 富文本编辑 | 图文混排、格式调整 | 中 |
| 内容审核 | 敏感词、人工审核流程 | 中 |
| 版本管理 | 历史版本、回滚 | 中 |
| 定时发布 | 定时任务、发布队列 | 低 |

### 3. 搜索系统
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 基础搜索 | 关键词匹配、模糊查询 | 低 |
| 高级搜索 | 多条件筛选、排序 | 中 |
| 全文检索 | Elasticsearch 集成 | 高 |
| 搜索建议 | 自动补全、热门搜索 | 中 |
| 搜索结果优化 | 权重调整、个性化推荐 | 高 |

### 4. 消息通知
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 站内信 | 消息列表、已读未读 | 低 |
| 推送通知 | APP 推送、浏览器推送 | 中 |
| 短信通知 | 验证码、通知短信 | 低 |
| 邮件通知 | 模板邮件、批量发送 | 低 |
| 消息模板 | 可配置模板、变量替换 | 中 |

### 5. 文件管理
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 文件上传 | 单文件、多文件、拖拽上传 | 低 |
| 文件存储 | 本地存储、OSS、CDN | 中 |
| 文件预览 | 图片、PDF、Office | 中 |
| 文件分享 | 链接分享、权限控制 | 低 |
| 文件版本 | 历史版本、版本对比 | 中 |

### 6. 数据统计
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 数据看板 | 核心指标展示、图表 | 中 |
| 报表生成 | 自定义报表、导出 | 中 |
| 数据导出 | Excel、CSV、PDF | 低 |
| 数据可视化 | 大屏、动态图表 | 高 |
| 用户行为分析 | 埋点、漏斗、留存 | 高 |

---

## 二、电商相关

### 1. 商品管理
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 商品列表 | 展示、筛选、排序 | 低 |
| 商品详情 | 规格、图片、详情描述 | 中 |
| 商品上下架 | 状态管理、定时上下架 | 低 |
| 库存管理 | 库存扣减、预警 | 中 |
| 价格管理 | 原价、活动价、会员价 | 中 |

### 2. 订单系统
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 下单流程 | 购物车、结算、提交 | 高 |
| 订单列表 | 多状态筛选、搜索 | 中 |
| 订单详情 | 商品、物流、支付信息 | 中 |
| 订单状态 | 待支付、待发货、已完成等 | 中 |
| 售后流程 | 退款、退货、换货 | 高 |

### 3. 支付系统
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 支付接入 | 微信、支付宝、银联 | 高 |
| 支付回调 | 异步通知、对账 | 高 |
| 退款处理 | 原路退回、部分退款 | 高 |
| 优惠券 | 发放、使用、核销 | 中 |
| 积分系统 | 获取、消费、兑换 | 中 |

### 4. 物流系统
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 运费模板 | 区域、重量、体积计费 | 中 |
| 物流跟踪 | 物流状态查询、展示 | 中 |
| 电子面单 | 打印、发货 | 中 |
| 多仓库 | 库存分配、就近发货 | 高 |

---

## 三、企业管理

### 1. OA 办公
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 考勤管理 | 打卡、请假、加班 | 中 |
| 审批流程 | 自定义流程、多级审批 | 高 |
| 公告通知 | 发布、已读未读 | 低 |
| 日程管理 | 日历、提醒、共享 | 中 |
| 会议管理 | 预定、通知、纪要 | 中 |

### 2. CRM 客户管理
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 客户档案 | 基本信息、联系人 | 低 |
| 跟进记录 | 沟通记录、下次跟进 | 中 |
| 销售漏斗 | 线索、商机、成交 | 中 |
| 客户分配 | 公海池、分配规则 | 中 |
| 业绩统计 | 销售报表、排行 | 中 |

### 3. 项目管理
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 项目列表 | 状态、进度、成员 | 中 |
| 任务管理 | 创建、分配、完成 | 中 |
| 甘特图 | 时间轴、依赖关系 | 高 |
| 工时统计 | 工时填报、汇总 | 中 |
| 文档协作 | 项目文档、版本 | 中 |

---

## 四、社交相关

### 1. 社交互动
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 关注系统 | 关注、粉丝、互相关注 | 低 |
| 点赞收藏 | 点赞、收藏、取消 | 低 |
| 评论系统 | 评论、回复、楼中楼 | 中 |
| 分享功能 | 生成海报、链接分享 | 中 |
| 消息聊天 | 单聊、群聊、已读 | 高 |

### 2. 内容社区
| 功能点 | 需求描述 | 复杂度 |
|--------|----------|--------|
| 内容发布 | 图文、视频、话题 | 中 |
| 内容推荐 | 推荐算法、信息流 | 高 |
| 用户主页 | 动态、作品、资料 | 中 |
| 话题/圈子 | 创建、加入、管理 | 中 |
| 内容举报 | 举报、处理、反馈 | 低 |

---

## 五、工时评估参考公式

### 基础公式
```
总工时 = ∑(各功能点工时 × 复杂度系数) + 集成工时 + 测试工时 + 缓冲工时
```

### 复杂度系数
- 简单：1.0
- 中等：1.5
- 复杂：2.0

### 集成工时
- 内部模块集成：总开发工时的 10%
- 第三方系统对接：每个接口 0.5-2 人天

### 缓冲工时
- 需求明确：总工时的 10%
- 需求模糊：总工时的 20-30%
