---
name: requirement-assessment
description: 需求细化与工时评估技能。接收用户需求（文本或截图），主动询问澄清问题，分析需求合理性，输出合并的需求清单 + 工时评估表，并创建飞书 Bitable 多维表。适用于项目立项、需求评审、工时估算场景。
---

# 需求评估技能

## 核心目标

理解清晰、准确、细化完善、风险可控、评估合理

---

## 工作流程

### 第一步：接收需求

用户可能提供：
- **文本需求**：直接描述功能或业务场景
- **截图/图片**：界面草图、流程图、参考图

### 第二步：主动询问（必须）

收到需求后，**必须主动询问以下关键问题**（根据需求情况选择相关问题）：

#### 客户背景
1. 这是老客户还是新客户？
2. 客户所属行业？是否有特殊合规要求？

#### 系统现状
3. 这是全新开发，还是在已有系统上补充/改造？
4. 如果是改造，原有系统技术栈是什么？是否有代码/文档可参考？

#### 需求边界
5. 需求的预期上线时间？是否有硬性 deadline？
6. 目标用户群体是谁？预计用户规模？
7. 是否需要多端支持（Web/iOS/Android/鸿蒙/小程序）？

#### 技术约束
8. 是否有指定的技术栈或平台要求？
9. 是否需要与现有第三方系统集成？有哪些系统？

#### 其他
10. 是否有参考产品或竞品？
11. 预算范围是否有预期？

### 第三步：需求分析

#### 3.1 需求合理性评估
- **技术可行性**：是否有成熟方案？技术风险点？
- **业务合理性**：是否解决真实痛点？使用频率？
- **成本效益**：投入产出比如何？是否有更优方案？

#### 3.2 需求细化
基于用户回答，将需求拆解为：
- 子系统/模块划分
- 功能点列表
- 各功能点详细描述

### 第四步：创建飞书 Bitable 多维表（直接输出）

**不再输出 markdown 表格，直接创建飞书多维表**。

**创建前询问用户**（如未提供）：
- 在哪个飞书空间/文件夹创建？（或使用默认空间）
- 表格名称（默认：`需求评估-YYYYMMDD-项目名称`）

**创建步骤**：
1. 使用 `feishu_bitable_create_app` 创建新的 Bitable 应用
2. 使用 `feishu_bitable_create_field` 创建以下字段
3. 使用 `feishu_bitable_create_record` 逐行创建记录
4. 返回 Bitable 链接给用户

**字段设计**（17 个字段）：

| 字段名 | 字段类型 | 说明 |
|--------|----------|------|
| 序号 | 自动编号 | 1001 类型 (AutoNumber) |
| 需求目标/场景 | 文本 | 1 类型 (Text) |
| 原始需求描述 | 文本 | 1 类型 (Text) |
| 子模块/子系统 | 单选 | 3 类型 (SingleSelect)，预设常见模块选项 |
| 功能点 | 文本 | 1 类型 (Text) |
| 需求描述 | 多行文本 | 1 类型 (Text) |
| 产品 | 数字 | 2 类型 (Number)，单位：人·天 |
| UI | 数字 | 2 类型 (Number)，单位：人·天 |
| 前端 | 数字 | 2 类型 (Number)，单位：人·天 |
| 后端 | 数字 | 2 类型 (Number)，单位：人·天 |
| 测试 | 数字 | 2 类型 (Number)，单位：人·天 |
| 运维 | 数字 | 2 类型 (Number)，单位：人·天 |
| iOS | 数字 | 2 类型 (Number)，单位：人·天 |
| Android | 数字 | 2 类型 (Number)，单位：人·天 |
| 鸿蒙 | 数字 | 2 类型 (Number)，单位：人·天 |
| 小计 (标准) | 数字 | 2 类型 (Number)，公式或手动计算 |
| 小计 (AI 辅助) | 数字 | 2 类型 (Number)，公式或手动计算 |

**工时说明**：
- **标准工时**：常规开发模式下的预估工时
- **AI 辅助工时**：在 AI 辅助（代码生成、文档生成等）情况下的预估工时
- 工时单位：人·天（允许小数）
- 如果某岗位不涉及，填 `0`

### 第五步：风险提示

列出主要风险点：
- 技术风险
- 需求变更风险
- 工期风险
- 其他风险

---

## 输出示例

### Bitable 记录示例

创建后的 Bitable 记录：
```
记录 1:
  - 序号：1
  - 需求目标/场景：用户登录
  - 原始需求描述："用户可以登录系统"
  - 子模块/子系统：用户系统
  - 功能点：手机号登录
  - 需求描述：用户输入手机号和验证码，验证通过后登录系统，支持 60 秒重发
  - 产品：0.5 | UI：0.5 | 前端：1 | 后端：1 | 测试：0.5 | 运维：0.2
  - iOS：0 | Android：0 | 鸿蒙：0
  - 小计 (标准)：3.7 | 小计 (AI 辅助)：2.5

记录 2:
  - 序号：2
  - 需求目标/场景：用户登录
  - 原始需求描述："用户可以登录系统"
  - 子模块/子系统：用户系统
  - 功能点：微信登录
  - 需求描述：用户点击微信登录，跳转微信授权，获取用户信息并绑定账号
  - 产品：0.5 | UI：0.3 | 前端：1.5 | 后端：2 | 测试：0.8 | 运维：0.2
  - iOS：0 | Android：0 | 鸿蒙：0
  - 小计 (标准)：5.3 | 小计 (AI 辅助)：3.5
```

---

## 注意事项

1. **必须主动询问**：不要直接给出评估，先问清楚背景
2. **工时合理**：基于 `references/评估标准.md` 的基准，结合需求复杂度调整
3. **风险透明**：不确定的地方要明确标注，不要过度承诺
4. **AI 辅助说明**：AI 辅助工时可作为参考，实际需考虑审核修改时间
5. **平台差异**：如果用户未指定平台，按 Web 评估，移动端单独列出
6. **Bitable 输出**：不再输出 markdown 表格，直接创建飞书多维表
7. **工时汇总**：可在 Bitable 中添加视图或使用公式字段自动计算各岗位合计

---

## 相关资源

- 评估标准和工时基准：`references/评估标准.md`
- 常见功能模块参考：`references/常见功能模块.md`
