---
name: tweet-writer
description: Write viral, persuasive, engaging tweets and threads. Uses web research to find viral examples in your niche, then models writing based on proven formulas and X algorithm optimization. Use when creating tweets, threads, or X content strategy.
---

# Tweet Writer Skill

## Overview

This skill helps you write viral, persuasive tweets and threads optimized for X's algorithm. It combines proven copywriting frameworks, viral hook formulas, and real-time research to model your content after successful examples in your niche.

**Keywords**: twitter, X, tweets, threads, viral content, social media, engagement, hooks, copywriting

## Process Workflow

### Phase 1: Niche Research (CRITICAL)

Before writing ANY tweet, you MUST research viral examples in the user's specific niche.

**Research Steps:**

1. **Identify the niche/topic** — What is the user writing about?
2. **Search for viral examples** — Use WebSearch to find:
   - `"[niche] viral tweet examples"`
   - `"[niche] twitter thread went viral"`
   - `"[topic] best performing tweets"`
   - `site:twitter.com OR site:x.com "[niche keyword]" high engagement`
3. **Analyze patterns** — Extract:
   - Hook styles that worked
   - Content structure
   - Tone and voice
   - Specific numbers/results used
   - CTAs that drove engagement
4. **Document insights** — Create a brief analysis before writing

**Example Research Prompt:**
```
Searching for: "SaaS founder viral tweets"
              "startup advice twitter thread viral"
              "tech entrepreneur best tweets engagement"
```

### Phase 2: Tweet Creation

Use the frameworks below to craft content modeled after successful examples.

---

## The X Algorithm (2026)

Understanding what the algorithm rewards is critical:

### Engagement Hierarchy (Most to Least Valuable)
1. **Replies** — Most weighted signal
2. **Quote tweets** — High value, shows your content sparks conversation
3. **Bookmarks** — Strong signal of value
4. **Retweets** — Amplification signal
5. **Likes** — Baseline engagement

### Time Sensitivity
- **First hour is critical** — If you don't gain traction in 60 minutes, reach drops significantly
- **Peak times**: 9-11 AM and 7-9 PM EST weekdays, 9-11 AM weekends
- Fresh content prioritized — X rewards recency

### Dwell Time
X tracks how long users spend on your content. Longer = more reach.
- Threads naturally increase dwell time
- Visual content keeps eyes on post longer
- Compelling hooks stop the scroll

### Format Boosts
- **Native video**: Priority over external links
- **Images/carousels**: 2x engagement vs text-only
- **Threads**: 3x engagement vs single tweets
- **Polls**: High participation signals

### What to AVOID
- **External links**: Severely penalized (especially for non-Premium accounts)
- **Generic content**: No differentiation = no reach
- **Asking for engagement**: "Like and RT" hurts reach

---

## Hook Formulas (The Most Critical Element)

Your hook determines 80-90% of your tweet's success. You have ~1 second to stop the scroll.

### The Bold Statement
```
"Nobody talks about this, but..."
"Unpopular opinion: [controversial take]"
"Everything you've been told about [X] is wrong."
"[Common belief] is a myth. Here's the truth:"
```

### The Specific Result
```
"I [specific result] in [specific timeframe]. Here's how:"
"[Number] [achievement] in [timeframe]. The breakdown:"
"From [bad state] to [good state] in [time]. Thread:"
```
**Example**: "I grew from 0 to 50K followers in 90 days. Here's the exact playbook:"

### The Curiosity Gap
```
"I found a [adjective] [topic] hack that no one talks about..."
"The one thing [type of person] gets wrong about [topic]"
"Why most people fail at [X] (and how to fix it)"
```

### The Question Hook
```
"Want to know the real secret to [X]?"
"What if everything you knew about [X] was wrong?"
"Ever wonder why [common frustration]?"
```

### The Story Hook
```
"3 years ago I was [bad state]. Today I [good state]."
"I almost quit [X]. Then this happened:"
"The story of how I [achievement] (with $0 budget):"
```

### The Pattern Interrupt
```
"Everyone says [X]. They're wrong."
"Stop doing [common practice]. Do this instead:"
"Delete [common thing]. Here's why:"
```

### The List Promise
```
"[Number] [things] that will [benefit] (thread):"
"[Number] lessons from [experience/achievement]:"
"The [number] [category] I wish I knew earlier:"
```
**Example**: "7 AI tools that saved me 20+ hours last week:"

---

## Tweet Formats That Go Viral

### Format 1: The Listicle (Highest Engagement)
```
Hook: "[Number] [things] that [benefit]:"

1. [Item] — [Brief explanation]
2. [Item] — [Brief explanation]
...
[CTA or summary]
```

### Format 2: The Contrarian Take
```
Hook: "[Popular belief] is wrong."

Here's why: [2-3 sentences of reasoning]

What actually works: [Your alternative]
```

### Format 3: The Before/After
```
[Time period] ago: [Bad state]
Today: [Good state]

The difference? [One key insight]
```

### Format 4: The Framework
```
Hook: "The [Name] Framework for [Result]:"

Step 1: [Action]
Step 2: [Action]
Step 3: [Action]

[Optional: brief expansion on each]
```

### Format 5: The "Fill in the Blank"
```
"The most underrated skill for _____ is _____."
"If I could only use one tool for [X], it would be _____."
```
*Generates massive replies*

### Format 6: The Universal Experience
```
"When you finally [common experience/realization]"
"Why does nobody talk about [shared frustration]?"
"That moment when [relatable situation]"
```

---

## Thread Structure (7-Tweet Sweet Spot)

### Thread Template

**Tweet 1 (Hook)**:
- Most compelling insight or result
- Include specific numbers
- Signal it's a thread: "🧵" or "(thread)"

**Tweet 2 (Context)**:
- Expand on the hook
- Set up why this matters
- Create more curiosity

**Tweets 3-6 (Core Value)**:
- ONE key insight per tweet
- Use numbered formatting (1/, 2/, etc.)
- Add visual breaks every 3-4 tweets (images, charts)
- Each tweet should be valuable standalone

**Tweet 7 (Bridge/Summary)**:
- Summarize key takeaways
- Connect to broader application

**Tweet 8 (CTA)**:
- Ask a question (generates replies)
- Quote your first tweet (drives retweets)
- Direct to profile/newsletter

### Thread Writing Rules
1. Each tweet must earn the next click
2. No filler — every word must carry weight
3. Short sentences (under 250 characters per tweet)
4. "Your words should read like a slippery slope"
5. Number your tweets (2/12, 3/12, etc.)

---

## Copywriting Frameworks for Tweets

### PAS (Problem → Agitate → Solution)
**Most reliable formula for engagement**

```
[Problem]: You're [specific situation]
[Agitate]: And it's costing you [consequence]
[Solution]: Here's what works: [your answer]
```

### AIDA (Attention → Interest → Desire → Action)
**Best for promotional content**

```
[Attention]: Hook that stops scroll
[Interest]: "Here's what most people don't realize..."
[Desire]: "Imagine if you could [benefit]"
[Action]: "DM me [X] to get started"
```

### BAB (Before → After → Bridge)
**Best for transformation stories**

```
[Before]: I was [bad state]
[After]: Now I'm [good state]
[Bridge]: The difference? [Your insight/solution]
```

---

## Persuasion Principles

Apply these to make any tweet more compelling:

**Specificity** — "23% increase" beats "big increase"
- Numbers add credibility
- Specific timeframes add urgency
- Details make claims believable

**Social Proof** — "500+ customers" beats "many customers"
- Results from real people
- Numbers of users/followers
- Recognizable names/brands

**Curiosity Gap** — Create information asymmetry
- Hint at valuable info without revealing all
- Promise specific outcomes
- Use "Here's what most people miss..."

**Controversy** — Challenge existing beliefs
- "Popular opinion is wrong"
- Contrarian takes get engagement
- Avoid offensive — aim for thought-provoking

**Relatability** — Shared experiences resonate
- "When you realize..."
- Universal frustrations
- Common journey points

---

## Growth Hacks

### The 30-Day Subtopic Strategy
Pick ONE narrow subtopic in your niche. Post about ONLY that for 30 days straight.

**Example**: If you're in marketing, focus solely on "email subject lines" for a month.

Result: X's algorithm categorizes you as the authority on that subtopic.

### The Reply Strategy
Focus on generating replies over likes/retweets.
- Ask questions
- Create fill-in-the-blank tweets
- Post "hot takes" that invite discussion
- Algorithm sees you as a conversation starter

### The Engagement Window
- Post 3-5 times daily
- Engage with 20+ accounts daily (meaningful replies)
- Reply to comments on your posts within first hour

### The 80/20 Rule
- 80% pure value (no promotion)
- 20% promotional content
- Value-first builds trust that converts

---

## Tweet Length Guidelines

- **Single tweets**: Under 110 characters perform best
- **Thread tweets**: Under 250 characters each
- **Why short works**: Easy to scan, room for quote tweets, mobile-optimized

---

## Common Pitfalls to Avoid

**Too Generic** — "Tips for success" → "3 cold email templates that got me 10 meetings this week"

**No Hook** — Starting with context instead of impact

**Asking for Engagement** — "Like and RT!" hurts reach

**External Links in Main Tweet** — Put links in replies instead

**No Specific Numbers** — "I grew fast" vs "I grew 12,847 followers in 63 days"

**Too Salesy** — Value ratio too low, feels promotional

**No CTA** — Thread ends with no clear next step

---

## Execution Checklist

Before posting, verify:

- [ ] Hook stops the scroll (bold/specific/curious)
- [ ] First 7 words earn the rest of the tweet
- [ ] Specific numbers included where relevant
- [ ] Under character limit (110 for single, 250 for thread tweets)
- [ ] No external links in main tweet
- [ ] Clear CTA or engagement driver
- [ ] Posted during peak hours
- [ ] Ready to engage with replies in first hour

---

## How to Use This Skill

When a user asks for help writing tweets:

1. **Ask for context**:
   - What niche/topic?
   - What's the goal? (engagement, followers, conversions)
   - What's the key message/insight?
   - Any specific results/numbers to include?

2. **Research phase** (USE WebSearch):
   - Search for viral examples in their niche
   - Identify successful patterns
   - Note specific hooks and structures that worked

3. **Draft options**:
   - Provide 2-3 hook variations
   - Use appropriate framework (PAS, AIDA, etc.)
   - Include specific numbers where possible

4. **Optimize**:
   - Check character count
   - Strengthen hook
   - Add engagement driver/CTA

5. **Provide variations**:
   - Single tweet version
   - Thread version (if appropriate)
   - Alternative hooks to test

---

## Integration with Other Skills

Tweet Writer works with:
- **Brand Voice** — Ensure tweets match your brand personality
- **Direct Response Copy** — Apply persuasion principles
- **Content Atomizer** — Turn one tweet into multiple formats
- **SEO Content** — Repurpose blog content into threads

---

## Research Sources & Further Reading

Algorithm insights: [SocialBee](https://socialbee.com/blog/twitter-algorithm/), [Tweet Archivist](https://www.tweetarchivist.com/how-twitter-algorithm-works-2025)
Hook formulas: [Ship 30 for 30](https://www.ship30for30.com/post/how-to-write-viral-twitter-thread-hooks-with-6-clear-examples)
Thread templates: [Typefully](https://typefully.com/blog/twitter-post-templates), [Legiit](https://legiit.com/blog/twitter-thread-template)
Copywriting frameworks: [Buffer](https://buffer.com/resources/copywriting-formulas/), [Metricool](https://metricool.com/social-media-copywriting/)
