# Vacation Rentals

## For Hosts

### Dynamic Pricing
Factors to adjust pricing:
- Day of week (weekends higher)
- Seasonality (holidays, events, peak season)
- Local events (concerts, conferences, sports)
- Booking lead time (last-minute vs advance)
- Length of stay (discounts for longer stays)
- Competition (what similar listings charge)

### Pricing Strategy
```
Base nightly rate:        $____
Weekend premium:          +___%
Peak season premium:      +___%
Local event premium:      +___%
Last-minute discount:     -___%
Weekly discount:          -___%
Monthly discount:         -___%
```

### Listing Optimization
- Professional photos (or at least well-lit, decluttered)
- Compelling headline with unique selling point
- Detailed amenities list
- Clear house rules
- Accurate location description
- Quick response to inquiries

### Guest Communication Templates

**Booking confirmation:**
```
Hi [Name], thanks for booking! Here's what you need:

Check-in: [time] on [date]
Check-out: [time] on [date]
Address: [full address]
Access: [lockbox code / key pickup instructions]

I'll send detailed check-in instructions closer to your arrival.
Let me know if you have any questions!
```

**Pre-arrival:**
```
Welcome! Your stay starts soon. Here's everything you need:

WIFI: [network] / Password: [password]
Parking: [instructions]
Check-in: [detailed access instructions]
House manual: [location or link]

My number for emergencies: [phone]
Please message me when you've arrived!
```

### Review Management
- Respond to all reviews (positive and negative)
- Thank guests specifically for positive feedback
- Address concerns professionally in negative reviews
- Never be defensive — acknowledge and explain improvements

---

## For Guests

### Search Strategy
- Book directly with hosts for potential discounts
- Check multiple platforms (Airbnb, VRBO, Booking.com)
- Read reviews chronologically (recent issues matter most)
- Check host response rate and response time
- Look for Superhost/Premier Host badges
- Verify cancellation policy before booking

### Reading Reviews
**Patterns to spot:**
- Cleanliness mentions (consistent = reliable signal)
- Location accuracy ("farther than expected")
- Communication quality
- Check-in smoothness
- Noise issues
- Photo accuracy ("smaller than pictured")

**Red flags:**
- Many mentions of same issue
- Host argues in responses
- Generic reviews (might be fake)
- No reviews in past 6 months

### Comparing Properties
Create comparison table:
| Factor | Property A | Property B | Property C |
|--------|-----------|-----------|-----------|
| Total cost (incl fees) | | | |
| Location rating | | | |
| Cleanliness mentions | | | |
| Recent review sentiment | | | |
| Cancellation policy | | | |
| Response time | | | |

### Communication with Hosts

**Pre-booking inquiry:**
```
Hi! I'm interested in [dates] for [number] guests.
A few questions:
1. [Specific question about listing]
2. [Question about neighborhood/parking/etc.]
3. Is early check-in possible?

Thanks!
```

**Issue during stay:**
```
Hi [Host], hope you're well.
I wanted to let you know about [specific issue].
It's not urgent but wanted you to be aware.
[If applicable: Do you have any suggestions?]
```

### Checkout Etiquette
- Follow checkout instructions
- Leave space reasonably tidy
- Report any damages honestly
- Leave review within 24 hours (memories fresh)
