# Tenant Guide

## Search Strategy

### Defining Criteria
Help user clarify must-haves vs nice-to-haves:
- **Hard requirements:** Max rent, bedrooms, pet policy, parking
- **Soft preferences:** Laundry, dishwasher, natural light, floor level
- **Deal-breakers:** Basement units, highway noise, no AC

### Search Sources
- Zillow, Apartments.com, Realtor.com — major aggregators
- Craigslist — good deals but more scams
- Facebook Marketplace/Groups — local listings
- Local property management companies — often not on aggregators
- Walking neighborhoods — "For Rent" signs

### True Cost Calculation

```
Monthly rent:           $____
+ Utilities (estimate): $____
+ Parking:              $____
+ Renter's insurance:   $____
+ Commute costs:        $____
= TRUE MONTHLY COST:    $____

One-time costs:
- Security deposit:     $____
- First/last month:     $____
- Application fees:     $____
- Moving costs:         $____
= MOVE-IN TOTAL:        $____
```

---

## Rental Application

### Documentation Checklist
- [ ] Government ID
- [ ] Proof of income (pay stubs, offer letter, tax returns)
- [ ] Bank statements (2-3 months)
- [ ] Credit report (or authorization)
- [ ] References (previous landlords, employer)
- [ ] Rental history with dates and addresses

### Application Cover Letter
For competitive markets, a brief letter helps:

```
Dear [Landlord/Property Manager],

I'm [name], a [profession] applying for [address]. 
I've been at my current job for [X years] with stable income of [X].
I'm looking for a long-term home and take pride in maintaining 
my living space. [Optional: brief note about why this specific unit].

I've attached all required documents and am happy to provide 
additional information. Thank you for considering my application.
```

---

## Negotiation

### What's Negotiable
- Monthly rent (especially for longer leases)
- Move-in date
- Lease length
- Security deposit amount
- Parking fees
- Pet deposits/fees
- Minor repairs before move-in
- Included utilities

### Leverage Points
- Market softness (vacancy rates, days on market)
- Longer lease commitment
- Excellent credit/references
- Willing to move in quickly
- Cash payment capabilities

### Negotiation Message Template
```
Hi [Name],

I'm very interested in [address] and ready to move forward quickly.
I noticed [comparable property] nearby is listed at [lower price].
Would you consider [specific ask: lower rent, reduced deposit, etc.]
if I commit to a [longer lease term/immediate move-in/etc.]?

I have excellent references and [stable income/etc.] — happy to 
provide any documentation that would help.
```

---

## Lease Review Checklist

### Critical Clauses
- [ ] Rent amount and due date
- [ ] Lease term and renewal terms
- [ ] Security deposit amount and return conditions
- [ ] Late fees and grace period
- [ ] Maintenance responsibilities (who fixes what)
- [ ] Subletting/guest policies
- [ ] Early termination clause
- [ ] Notice period to vacate

### Red Flags
- Automatic lease renewal without notice
- Excessive late fees (>5% or flat fee >$50)
- Landlord can enter without notice
- Vague maintenance responsibilities
- "As-is" condition with no move-in inspection
- Personal liability for building issues
- Mandatory arbitration clauses

### Move-In Documentation
Always document unit condition before moving in:
- Photo/video walkthrough with timestamp
- Note existing damage on move-in checklist
- Send copy to landlord via email (creates record)
- Keep copies of all signed documents
