# Landlord Guide

## Pricing Strategy

### Market Analysis
To set competitive rent:
1. Search comparable units (same bedrooms, similar condition)
2. Check active listings AND recent rentals
3. Factor in: location quality, amenities, condition, parking
4. Price slightly below market for faster occupancy

### Pricing Formula
```
Comparable rent average:  $____
Adjustments:
+/- Location premium:     $____
+/- Condition factor:     $____
+/- Amenities:            $____
+/- Parking:              $____
= TARGET RENT:            $____

Vacancy cost per month of empty: $____
(Often worth pricing $50-100 lower to fill faster)
```

---

## Listing Creation

### Effective Listing Structure
1. **Headline:** Bedrooms + standout feature + neighborhood
2. **Key facts:** Rent, deposit, available date, lease term
3. **Description:** 2-3 paragraphs highlighting best features
4. **Amenities list:** Bullet points for scanning
5. **Requirements:** Credit, income, pet policy
6. **Contact info:** How to schedule viewing

### Photo Checklist
- [ ] Exterior/building front
- [ ] Living room (multiple angles)
- [ ] Kitchen (show appliances)
- [ ] All bedrooms
- [ ] Bathrooms
- [ ] Storage/closets
- [ ] Outdoor space if applicable
- [ ] Parking
- [ ] Laundry facilities

**Photo tips:** Shoot during day with lights on, declutter, wide angles.

---

## Tenant Screening

### Application Requirements
- Government ID verification
- Income verification (3x rent minimum typical)
- Credit check (score + payment history)
- Background check
- Previous landlord references
- Employment verification

### Reference Questions
For previous landlords:
1. How long did they rent from you?
2. Did they pay rent on time?
3. How did they maintain the property?
4. Did they give proper notice?
5. Would you rent to them again?

### Red Flags
- Income doesn't meet 3x rent
- Multiple recent addresses
- Eviction history
- Reluctance to provide references
- Pressure to skip screening steps
- Inconsistent information

---

## Property Management

### Maintenance Categories
| Urgency | Response | Examples |
|---------|----------|----------|
| Emergency | Immediate | No heat in winter, flooding, gas leak, no water |
| Urgent | 24-48 hours | No hot water, broken lock, fridge not working |
| Standard | 3-7 days | Leaky faucet, appliance issues, minor repairs |
| Routine | Scheduled | Seasonal maintenance, cosmetic updates |

### Documentation
For every maintenance request:
- Date and time reported
- Issue description
- Photos if applicable
- Action taken
- Completion date
- Cost if any

### Rent Collection
- Set clear due date (typically 1st of month)
- Define grace period (3-5 days typical)
- Establish late fee policy
- Use consistent payment method
- Document all payments received

---

## Legal Compliance

### Required Knowledge
- Local landlord-tenant laws
- Fair housing regulations
- Security deposit rules (limits, interest, return timeline)
- Required disclosures (lead paint, mold, etc.)
- Eviction procedures
- Habitability requirements

### Prohibited Discrimination (Fair Housing)
Cannot discriminate based on:
- Race, color, national origin
- Religion
- Sex/gender
- Familial status
- Disability

### Documentation to Keep
- Signed lease
- All correspondence
- Maintenance records
- Payment records
- Move-in/move-out inspections
- Any notices served
