# Equipment & Vehicle Rentals

## Car Rentals

### Price Comparison
Always check:
- Direct rental company websites
- Aggregators (Kayak, Google, AutoSlash)
- Credit card portals (often have discounts)
- Membership discounts (AAA, Costco, corporate)

### Hidden Fees to Watch
| Fee | Typical Cost | How to Avoid |
|-----|--------------|--------------|
| Airport surcharge | 10-15% | Rent off-airport location |
| Young driver fee | $20-30/day | Age 25+ or corporate account |
| Additional driver | $10-15/day | Some cards include this |
| GPS rental | $10-15/day | Use phone instead |
| Fuel service | 2-3x pump price | Return full |
| Toll transponder | $5-10/day | Bring your own or pay cash |
| One-way drop | $50-300 | Return to same location |

### Insurance Decision Tree
```
Do you have personal auto insurance?
├─ Yes → Does it cover rentals? (Check policy)
│   ├─ Yes → Decline rental insurance (but verify coverage limits)
│   └─ No → Consider rental insurance
└─ No → 
    Does your credit card offer rental coverage?
    ├─ Yes → Pay with that card, decline rental insurance
    │        (but understand card coverage limitations)
    └─ No → Purchase rental insurance
```

### Credit Card Coverage
Many cards offer rental coverage:
- **Primary coverage:** Pays first (better)
- **Secondary coverage:** Pays after your insurance

Requirements typically:
- Decline rental company's insurance
- Pay entire rental with that card
- May not cover trucks, SUVs, or luxury vehicles
- Usually limited to 30-60 day rentals
- May exclude certain countries

### Pickup/Return Checklist
**At pickup:**
- [ ] Walk around vehicle, note all damage
- [ ] Take photos/video with timestamp
- [ ] Check fuel level
- [ ] Verify mileage on contract
- [ ] Test lights, wipers, AC
- [ ] Confirm return time/location

**At return:**
- [ ] Fill tank to required level
- [ ] Take photos showing fuel gauge
- [ ] Remove all belongings
- [ ] Get return receipt
- [ ] Save documentation for 30 days

---

## Tool & Equipment Rentals

### When to Rent vs Buy
**Rent when:**
- One-time or rare use
- Expensive equipment
- Storage is limited
- Want to try before buying
- Need professional-grade temporarily

**Buy when:**
- Regular use (>3-4 times/year)
- Total rental cost exceeds purchase
- Long-term project
- Availability concerns

### Rental Sources
- Home Depot, Lowe's — common tools, good availability
- Local rental shops — often better selection, expertise
- Peer-to-peer (Fat Llama, etc.) — unique items
- Specialty suppliers — professional equipment

### Equipment Rental Checklist
**Before renting:**
- [ ] Confirm what's included (accessories, consumables)
- [ ] Understand operation (ask for demo)
- [ ] Check condition and test
- [ ] Clarify damage policy
- [ ] Get emergency contact

**During rental:**
- [ ] Follow operating instructions
- [ ] Don't exceed rated capacity
- [ ] Document any issues immediately
- [ ] Keep receipts for fuel/consumables

**At return:**
- [ ] Clean equipment
- [ ] Return all accessories
- [ ] Refuel if required
- [ ] Note any damage or issues
- [ ] Get signed return confirmation

---

## Damage Disputes

### Prevention
- Document condition at pickup (photos, video)
- Report pre-existing damage immediately
- Keep all documentation
- Take return photos before leaving

### If Disputed
1. Request itemized damage report with photos
2. Provide your pickup documentation
3. Compare timestamps
4. Dispute in writing with evidence
5. Credit card chargeback if unresolved

### Damage Claim Response Template
```
I'm disputing the damage charges for rental [confirmation #].

I documented the vehicle condition at pickup on [date/time].
Attached photos show [description of pre-existing condition].
The damage you're claiming was present before my rental.

Please review the attached documentation and remove these charges.
If charges aren't removed, I'll dispute with my credit card company.

[Attach dated photos from pickup]
```

---

## Loyalty Programs

### Worth It When
- Frequent rentals (5+ per year)
- Value counter bypass and faster service
- Want free upgrades
- Status matches across programs

### Major Car Rental Programs
- Hertz Gold Plus
- National Emerald Club
- Enterprise Plus
- Avis Preferred
- Budget Fastbreak

**Tip:** Many programs offer instant status match — check before joining.
