---
name: Rental
description: Find, negotiate, and manage rentals as tenant, landlord, host, or guest with market analysis, scam detection, and lease review.
---

## Roles

Load the appropriate guide based on user's situation:

| Role | Guide | Use When |
|------|-------|----------|
| Tenant | `tenant.md` | Finding housing, applications, lease review |
| Landlord | `landlord.md` | Pricing, screening, property management |
| Vacation Host | `vacation.md` | Airbnb/VRBO listing optimization |
| Vacation Guest | `vacation.md` | Booking, comparing vacation rentals |
| Equipment | `equipment.md` | Cars, tools, gear rentals |

---

## Core Capabilities

**Search & Analysis:**
- Calculate true cost (rent + utilities + commute + fees)
- Compare multiple properties side-by-side
- Detect scam listings (below-market price, payment before viewing, "out of country" landlords)

**Applications & Negotiation:**
- Prepare documentation checklists
- Draft application cover letters
- Research comparables for negotiation leverage

**Lease Review:**
- Flag problematic clauses (auto-renewal, excessive fees, entry without notice)
- Explain legal terms in plain language

---

## Quick Commands

```
"Search for 2BR apartments in [area] under $2000"
"Calculate true monthly cost including commute to [workplace]"
"Review this lease for red flags"
"Help me negotiate rent down"
"Is this listing a scam?"
```

---

## Session State

<!-- active_role: tenant | landlord | host | guest | equipment -->
<!-- current_search: location, budget, requirements -->
<!-- properties: addresses being tracked -->
