---
name: renderful-generation
description: Use Renderful from OpenClaw for image/video/audio/3D creation with model discovery, quote-before-generate workflow, deterministic polling, and insufficient-funds/x402 fallback.
metadata: {"openclaw":{"homepage":"https://renderful.ai"}}
---

Use this skill with the Renderful OpenClaw plugin tools:
- `renderful_list_models`
- `renderful_quote`
- `renderful_generate`
- `renderful_get_generation`
- `renderful_register_agent`
- `renderful_get_balance`
- `renderful_set_webhook`

## Recommended Flow

1. Run `renderful_register_agent` if no API key is available.
2. Run `renderful_list_models` to pick a valid `type` and `model`.
3. Run `renderful_quote` before `renderful_generate`.
4. Run `renderful_generate` once inputs are validated.
5. Poll with `renderful_get_generation` until terminal status.

## x402 and Insufficient Funds

- If generation returns `status=402`, surface `payment_requirements`.
- If `needs_funds=true`, surface `deposit_addresses` and `shortfall`.
- Retry generation after funding or after providing valid `x_payment`.

## Notes

- Prefer read-only calls (`list_models`, `quote`, `get_generation`, `get_balance`) until explicit user approval for side effects.
- Keep responses deterministic and structured so planners can chain tool calls safely.
