#!/usr/bin/env bash
set -euo pipefail

if [[ $# -lt 2 ]]; then
  echo "Usage: $0 <in.stl> <out.png> [renderer args...]" >&2
  exit 2
fi

IN_STL="$1"
OUT_PNG="$2"
shift 2

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
VENV_BASE="${XDG_CACHE_HOME:-$HOME/.cache}/agent-skills"
VENV="$VENV_BASE/render-stl-png-venv"

mkdir -p "$VENV_BASE"

if [[ ! -x "$VENV/bin/python" ]]; then
  python3 -m venv "$VENV"
  "$VENV/bin/pip" install --upgrade pip >/dev/null
  "$VENV/bin/pip" install pillow >/dev/null
fi

exec "$VENV/bin/python" "$SCRIPT_DIR/render_stl_png.py" --stl "$IN_STL" --out "$OUT_PNG" "$@"
