# render-stl-png

Render an STL to a PNG from a nice, consistent 3D angle ("Blender-ish" default perspective) with a solid color.

This is a **deterministic software renderer**:
- No OpenGL
- No Blender dependency
- Uses a simple camera + z-buffer + Lambert shading

## Inputs

- STL file path (ASCII or binary)
- Output PNG path

## Parameters

- `--size <px>`: image width/height (square), default `1024`
- `--bg "#rrggbb"`: background color, default `#0b0f14`
- `--color "#rrggbb"`: mesh base color, default `#4cc9f0`
- `--azim-deg <deg>`: camera azimuth around Z, default `-35`
- `--elev-deg <deg>`: camera elevation, default `25`
- `--fov-deg <deg>`: perspective field of view, default `35`
- `--margin <0..0.4>`: framing margin as fraction of view, default `0.08`
- `--light-dir "x,y,z"`: directional light vector, default `-0.4,-0.3,1.0`

## Usage

### One-shot

```bash
python3 scripts/render_stl_png.py \
  --stl /path/to/model.stl \
  --out /tmp/model.png \
  --color "#ffb703" \
  --bg "#0b0f14" \
  --size 1200
```

### Wrapper (recommended)

The wrapper creates a cached venv (so `pillow` is available) and runs the renderer.

```bash
bash scripts/render_stl_png.sh /path/to/model.stl /tmp/model.png --color "#ffb703"
```

## Notes

- This is meant for **marketing/preview images**, not photorealism.
- If you need studio lighting / materials, use Blender — but this gets you 80% quickly and reproducibly.
