---
name: removebg-api
description: Remove image backgrounds using the remove.bg API with API-key auth and transparent PNG output. Use when high-quality cutouts are needed and cloud processing is acceptable.
metadata:
  {
    "openclaw": {
      "requires": { "bins": ["uv", "python3"], "env": ["REMOVE_BG_API_KEY"] },
      "primaryEnv": "REMOVE_BG_API_KEY"
    }
  }
---

# removebg-api

Use remove.bg for high-quality background removal.

## API key setup

1. Create/sign in at `https://www.remove.bg/dashboard#api-key`
2. Create an API key
3. Configure `REMOVE_BG_API_KEY` in OpenClaw config (`openclaw.json`) so it is present in runtime environment.

## Important

- Skill metadata (`requires.env`) declares that `REMOVE_BG_API_KEY` is required.
- Metadata does **not** auto-load shell env files.
- Preferred: provide key via OpenClaw config-managed environment.

## Usage (preferred: uv)

Run from the skill directory:

```bash
uv run scripts/removebg_api.py --input /path/in.jpg --output /path/out.png
```

Options:

- `--size auto|preview|full|4k` (default: `auto`)
- `--format png|jpg|zip` (default: `png`)
Security defaults:

- `--input` must be a real image file *inside the OpenClaw workspace*.
- Allowed input types: `.png`, `.jpg`, `.jpeg`, `.webp` (extension + magic-byte validation).
- `--output` must be under `outputs/removebg-api/` inside the workspace.
- Large/abusive files are rejected (size + dimension limits).
- This prevents arbitrary file read/write outside normal skill boundaries.

Example:

```bash
uv run scripts/removebg_api.py --input ./input.jpg --output ./output.png --size auto --format png
```

## Fallback (without uv)

```bash
python3 scripts/removebg_api.py --input ./input.jpg --output ./output.png
```

## Output

- Writes result file to `--output`
- Prints `MEDIA:` line for chat workflows

## Notes

- API usage may consume free credits / paid quota.
- No absolute-path requirement for skill docs; use local paths in examples.
