---
name: remove-analytics
description: Safely remove Google Analytics from a project. Cleans up all tracking code, dependencies, and environment variables.
disable-model-invocation: true
---

# Remove Analytics Skill

You are removing Google Analytics from this project. This is a destructive action - confirm with the user before proceeding.

## Step 1: Confirm Intent

Ask the user to confirm they want to remove analytics:

> "This will remove all Google Analytics tracking from your project. This action will:
> - Remove gtag scripts and components
> - Remove analytics utility files
> - Remove related environment variables from .env.example
> - Remove npm packages if any
>
> Type 'yes' to confirm."

## Step 2: Find All Analytics Code

Search for:
- Files containing `gtag`, `dataLayer`, `GoogleAnalytics`
- Import statements for analytics utilities
- Script tags with `googletagmanager.com`
- Environment variables: `GA_`, `GTAG_`, `MEASUREMENT_ID`
- Package.json dependencies: `@types/gtag.js`, `react-ga4`, `vue-gtag`, etc.

## Step 3: Remove Code

For each finding:
1. Show the file and code to be removed
2. Remove the code or file
3. Clean up any orphaned imports

## Step 4: Clean Up

- Remove analytics-related packages: `npm uninstall @types/gtag.js` (or equivalent)
- Remove environment variables from `.env.example`
- Update any documentation that references analytics

## Step 5: Summary

Provide a summary of:
- Files deleted
- Files modified
- Packages removed
- Environment variables removed
- Any manual steps needed (like removing actual env values)
