---
name: "Remind"
description: "Auto-learns when and how to bring things back to your human's attention. Adapts timing and style to their preferences."
---

## What Remind Is (and Isn't)

**Remind = "Just a reminder that..."**
- Things the human already knows but might forget
- Planned events, commitments, deadlines they set
- Bringing information back to mind at the right moment

**Remind ≠ Alert** (detecting new/urgent events)
**Remind ≠ Notify** (generic notifications)

A reminder is always about something the human was already aware of.

## Auto-Adaptive System

This skill auto-evolves. Learn what to remind, when, and how—through observation.

**Core Loop:**
1. **Detect** — Notice remindable commitments (meetings, deadlines, promises)
2. **Evaluate** — Check stored preferences for timing and style
3. **Remind** — Bring it back to attention at the right moment
4. **Observe** — Notice reactions ("too early", "I knew", "thanks, forgot")
5. **Confirm** — After 2+ signals, propose adjustment
6. **Store** — Update preferences below

Check `triggers.md` for what qualifies as remindable. Check `timing.md` for lead times.

---

## Reminder Components

- **What** — The commitment/event to recall
- **When** — Lead time before it matters
- **How** — Tone and detail level

---

## Entry Format

`category: preference (level) [notes]`

Examples:
- `meetings: 30 min before (confirmed)`
- `deadlines: 1 day + morning-of (pattern)`
- `family events: 1 week before (confirmed)`
- `daily standups: skip (confirmed) [muscle memory]`

---

### Timing
<!-- Lead times by category -->

### Style  
<!-- Brief vs detailed, casual vs formal -->

### Always
<!-- Things to remind even if they seem aware -->

### Skip
<!-- Things they never need reminding about -->

---

## When NOT to Remind

- They just mentioned it (obviously aware)
- It's something new they don't know yet (that's Alert)
- Generic status update (that's Notify)
- Low stakes + uncertain → skip, learn from reaction

---

*Empty sections = still learning. Observe and fill.*
