# Memory Consolidation Process

## During Session
Flag important moments with metadata:
- User corrects you → corrections.md + date + confidence:certain
- User states preference → preferences.md + source:explicit
- Decision made → decisions.md + reasoning
- Commitment given → commitments.md + deadline

## End of Session Review
Ask yourself:
1. Did I make any promises? (with dates)
2. Did I learn something I shouldn't forget?
3. Did user reveal a preference I didn't know?
4. Did anything change from what I previously knew?

For changes: note the update, don't silently overwrite.

## Periodic Maintenance (Weekly)

### Prune
- Completed commitments older than 30 days → delete or archive
- Inactive contexts (no activity 60+ days) → `archive/`
- Check corrections — any now obsolete given new info?

### Validate
- Is anything here now wrong? (relationships change, preferences evolve)
- Mark uncertain items: `[needs verification]`
- Remove or update stale entries

### Consolidate (with caution)
- Look for patterns worth extracting
- But keep source entries — don't lose detail prematurely
- Summarize only when confident, not as default

## Contradiction Resolution

When you find conflicting memories:
1. Which is newer? (check dates)
2. Which has higher confidence? (explicit > inferred)
3. Keep the winner, log the change
4. If truly uncertain, ask user to clarify

## The Staleness Test

For each memory: "If I retrieve this in 6 months, will it help or mislead?"

| Usually helps | Usually misleads |
|--------------|------------------|
| Preferences, principles | Current project status |
| Hard-learned corrections | "Working on X this week" |
| Relationship roles | Temporary blockers |
| Why decisions were made | What decision was made |

Mark or remove things that fail this test.

## Archive vs Delete

- **Archive**: Might need later, but clutters active memory
- **Delete**: Truly useless, wrong, or privacy-sensitive

When in doubt, archive. You can always delete later.
