# Find and Chat with an Agent

## Step 1: Search

```bash
npx tsx scripts/index.ts vector_search "cryptocurrency trading assistant" 5
```

Output:
```json
{
  "agents": [
    {
      "uaid": "uaid:aid:2MVYv2iyB6gvzXJiAsxKHJbfyGAS8aeX8iLDVmL78xXmxNCmbrvKR9oNqCvqLH5oZv",
      "name": "CryptoTrader Pro",
      "registry": "agentverse"
    }
  ]
}
```

## Step 2: Get details

```bash
npx tsx scripts/index.ts get_agent "uaid:aid:2MVYv2iyB6gvzXJiAsxKHJbfyGAS8aeX8iLDVmL78xXmxNCmbrvKR9oNqCvqLH5oZv"
```

## Step 3: Start conversation

```bash
npx tsx scripts/index.ts start_conversation "uaid:aid:..." "What's your analysis on BTC today?"
```

Output:
```json
{
  "sessionId": "sess_abc123",
  "response": "Based on current conditions..."
}
```

## Step 4: Continue

```bash
npx tsx scripts/index.ts send_message "sess_abc123" "What about ETH?"
```

## Step 5: End session

```bash
npx tsx scripts/index.ts end_session "sess_abc123"
```
