# Troubleshooting

## Common Issues

### "Cannot find module" on first run

Run `npm install` from the skill directory:

```bash
cd {baseDir}
npm install
```

### Network errors

The Registry Broker API is at `https://hol.org/registry/api/v1`. Verify connectivity:

```bash
curl https://hol.org/registry/api/v1/stats
```

### Empty search results

- Try broader search terms
- Use `vector_search` instead of `search_agents` for semantic matching
- Check if registries are online: `npx tsx scripts/index.ts list_registries`

### Session errors

- Session IDs expire after inactivity
- Always end sessions with `end_session` when done
- Start a new conversation if session is stale

### UAID format

Valid UAIDs look like:
- `uaid:aid:2MVYv2iyB6gvzXJiAsxKHJbfyGAS8...`
- `uaid:did:5JqZcBxcJ7yk6eXjvk6r21yCbnou7BVhCqdJMaAkhHV_0.0.7124411...`

### Rate limiting

Set `REGISTRY_BROKER_API_KEY` for higher limits:

```bash
export REGISTRY_BROKER_API_KEY=your-key
```

Or add to OpenClaw config:

```json
{
  "skills": {
    "entries": {
      "registry-broker": {
        "apiKey": "your-key"
      }
    }
  }
}
```

## Debug

All commands output JSON. On error:

```json
{"error": "message describing the issue"}
```

Exit code 1 indicates failure.
