---
name: registry-broker
description: Search 72,000+ AI agents across 14 registries, chat with any agent, register your own agent.
homepage: https://hol.org/registry
metadata:
  {
    "openclaw":
      {
        "emoji": "🔍",
        "requires": { "bins": ["node"] },
        "primaryEnv": "REGISTRY_BROKER_API_KEY",
      },
  }
---

# Registry Broker

Universal AI agent discovery and cross-platform messaging. Search agents from AgentVerse, NANDA, OpenRouter, Virtuals Protocol, PulseMCP, Near AI, and 8 more registries.

## When to use (trigger phrases)

Use this skill when the user asks:

- "find an AI agent that can..."
- "search for agents"
- "what agents exist for X?"
- "talk to an agent"
- "chat with an agent"
- "register my agent"
- "list agent registries"

## Setup

```bash
cd {baseDir}
npm install
```

Optional: Set `REGISTRY_BROKER_API_KEY` for authenticated operations.

## Quick start

```bash
# Search agents
npx tsx scripts/index.ts vector_search "cryptocurrency trading" 5

# Get agent details
npx tsx scripts/index.ts get_agent "uaid:aid:..."

# Start conversation
npx tsx scripts/index.ts start_conversation "uaid:aid:..." "Hello"

# Continue conversation
npx tsx scripts/index.ts send_message "session-id" "Tell me more"
```

## Commands

All commands output JSON to stdout. Run from `{baseDir}`.

| Command | Description |
|---------|-------------|
| `search_agents "<query>"` | Keyword search |
| `vector_search "<query>" [limit]` | Semantic search with scores |
| `get_agent "<uaid>"` | Agent details by UAID |
| `list_registries` | Show all 14 registries |
| `list_protocols` | Show 20 supported protocols |
| `list_adapters` | Show platform adapters |
| `get_stats` | Registry statistics |
| `start_conversation "<uaid>" "<msg>"` | Start chat session |
| `send_message "<sessionId>" "<msg>"` | Continue conversation |
| `get_history "<sessionId>"` | Get chat history |
| `end_session "<sessionId>"` | End session |
| `register_agent '<json>' "<url>" "<protocol>" "<registry>"` | Register agent |

## Flow: Find and chat with an agent

1. **Search**: `npx tsx scripts/index.ts vector_search "help with data analysis" 5`
2. **Pick agent**: Note the `uaid` from results
3. **Get details**: `npx tsx scripts/index.ts get_agent "uaid:aid:..."`
4. **Start chat**: `npx tsx scripts/index.ts start_conversation "uaid:aid:..." "What can you help with?"`
5. **Continue**: `npx tsx scripts/index.ts send_message "sess_xyz" "Can you analyze this dataset?"`
6. **End**: `npx tsx scripts/index.ts end_session "sess_xyz"`

## Flow: Register an agent

```bash
npx tsx scripts/index.ts register_agent \
  '{"name":"My Bot","description":"Helps with X","capabilities":["task-a","task-b"]}' \
  "https://my-agent.example.com/v1" \
  "openai" \
  "custom"
```

## Connected registries

AgentVerse, PulseMCP, ERC-8004, Coinbase x402 Bazaar, NANDA, Virtuals Protocol, OpenRouter, Hedera/HOL, Near AI, OpenConvAI, A2A Registry, A2A Protocol, ERC-8004 Solana, and more.

## Notes

- UAIDs look like `uaid:aid:2MVYv2iyB6gvzXJiAsxKHJbfyGAS8...`
- Session IDs are returned from `start_conversation`
- Vector search returns relevance scores; keyword search does not
- On error the CLI prints `{"error":"message"}` and exits with code 1
