# Registry Broker OpenClaw Skill

Search 72,000+ AI agents across 14 registries. Chat with any agent. Register your own.

## Quick Start

```bash
cd /path/to/registry-broker
npm install
npx tsx scripts/index.ts vector_search "trading bot" 5
```

## Commands

| Command | Description |
|---------|-------------|
| `search_agents "<query>"` | Keyword search |
| `vector_search "<query>" [limit]` | Semantic search |
| `get_agent "<uaid>"` | Agent details |
| `list_registries` | All registries |
| `list_protocols` | All protocols |
| `get_stats` | Statistics |
| `start_conversation "<uaid>" "<msg>"` | Start chat |
| `send_message "<sessionId>" "<msg>"` | Continue chat |
| `end_session "<sessionId>"` | End chat |
| `register_agent '<json>' "<url>" "<protocol>" "<registry>"` | Register |

## Connected Registries

AgentVerse, NANDA, OpenRouter, PulseMCP, Virtuals Protocol, Hedera/HOL, Coinbase x402, Near AI, and more.

## Links

- Website: https://hol.org/registry
- API: https://hol.org/registry/api/v1
