# Memory Template — Self Reflection

Copy this structure to `~/reflection/memory.md` on first activation.

---

```markdown
# Self Reflection — Memory

## Status
- streak_days: 0
- total_reflections: 0
- patterns_active: 0
- patterns_resolved: 0
- last_review: never
- installed: YYYY-MM-DD

## Preferences
- review_day: Sunday
- archive_threshold: 20
- reflection_depth: standard

## Stats by Category
| Category | Count | Last |
|----------|-------|------|
| technical | 0 | - |
| communication | 0 | - |
| assumptions | 0 | - |
| process | 0 | - |
| scope | 0 | - |

## Active Patterns
(Populated when patterns detected)

## Recent Milestones
(Populated as streaks are achieved)
```

---

## reflections.md Template

```markdown
# Reflections Log

Most recent first. Archive when >20 entries.

<!-- Template for new entry:
## YYYY-MM-DD | [category]
**Miss:** What went wrong
**Root:** Why it happened
**Fix:** Prevention rule
**Pattern:** new | extends:name | none
-->
```

---

## patterns.md Template

```markdown
# Detected Patterns

## How to Use
- Scan this file before starting work in a domain
- Surface relevant patterns proactively
- Update streak when pattern avoided

<!-- Template for new pattern:
## [Pattern Name]
category: [category]
frequency: X occurrences
status: emerging | active | monitoring | resolved

**Pattern:** What keeps happening
**Root:** Why this pattern exists
**Prevention:** Rule to break it
**Evidence:** Links to reflections
**Last seen:** YYYY-MM-DD
**Streak:** X days since last occurrence
-->
```
