---
name: refactor-safely
description: Plans and executes safe refactors with small steps, tests, and rollback strategy. Use when 重构, 技术债, 安全重构, refactoring, or improving code structure without breaking behavior.
---

# 安全重构（Refactor Safely）

在不改变对外行为的前提下，分步、可验证地改善代码结构，降低技术债与回归风险。

## 触发场景

- 用户说「重构这段代码」「清理技术债」「安全重构」「改善结构但不要改行为」
- 代码难以维护、重复多、职责混乱、难以加测试

## 原则

- **行为不变**：重构前后功能与边界行为一致（含异常、边界值）
- **小步提交**：每步可单独提交、易回滚、易 code review
- **先测后动**：有测试则先绿再动；无测试则先补关键路径再重构
- **可随时停**：任意一步停下，代码仍处于可运行、可发布状态

## 执行流程

### 1. 明确范围与目标

- **范围**：单文件 / 单模块 / 跨模块（列出受影响入口与调用方）
- **目标**：例如「抽公共函数」「拆组件」「统一错误处理」「去掉重复」
- **不做什么**：明确不在此次重构里改的需求或行为

### 2. 识别依赖与风险

- 谁在调用当前代码（组件、API、路由、全局状态）
- 是否有隐式依赖（全局变量、副作用、执行顺序）
- 高风险点：无类型、无测试、多入口共用的逻辑

### 3. 拆分步骤（每步可单独提交）

| 步骤类型 | 示例 |
|----------|----------|
| 仅移动 | 把函数/组件挪到新文件，改 import，跑通 |
| 仅重命名 | 变量/函数/文件重命名，全局替换后跑通 |
| 抽离不改逻辑 | 抽子函数/子组件，原逻辑不变，调用处改为用新的 |
| 替换实现 | 用新实现替换旧实现，对外接口不变 |
| 删废弃 | 确认无引用后删除死代码或废弃 API |

### 4. 每步验证

- 构建通过、类型通过、现有测试通过
- 若有可能：关键页面/流程手工点一遍或跑 E2E
- 提交信息写清本步做了什么（如 "refactor: extract getDisplayName"）

### 5. 回滚策略

- 每步在版本控制里独立提交，便于 `git revert`
- 若涉及配置或数据，注明回滚时需恢复的内容

## 输出模板

```markdown
## 安全重构计划

### 目标与范围
- 目标：…
- 范围：…（文件/模块列表）
- 不改变：…（行为/接口约定）

### 依赖与风险
- 调用方：…
- 风险点：…

### 步骤（每步可单独提交）
1. … — 验证：…
2. … — 验证：…
3. …

### 回滚
- 按提交逐条 revert 即可 / 需注意：…
```

## 常见模式

- **抽函数**：先复制一份成新函数，调用处改为新函数，再删旧实现
- **抽组件**：先在新文件写组件，原处用新组件包裹原 JSX，再逐步把 props 捋清
- **改数据结构**：可先兼容旧结构（新旧并存），再逐步迁移调用方，最后删旧结构
- **重命名**：用 IDE 重命名/全局替换，避免手改漏改
