# Negotiation — Close Deals and Protect Your Value

Negotiate rates, scope, and terms using Chris Voss's FBI-proven frameworks adapted for freelance and consulting deals.
Sources: Chris Voss (Never Split the Difference), Gong.io, NAHC, Klenty, Aviso.
All outputs go to `workspace/artifacts/`.

## Use when
- Negotiating rates with a client (Upwork, direct, retainer)
- Client pushes back on pricing after proposal
- Scope creep discussion — client wants more without paying more
- Contract terms negotiation (payment schedules, milestones, IP)
- Equity/revenue share deals (like Alfred)
- Any conversation where money or terms are on the table

## Don't use when
- Initial discovery (use client-discovery skill — negotiate AFTER you understand their needs)
- Writing the proposal itself (use proposal-writing skill)
- Handling generic objections before the money talk (use objection-handling skill)
- Internal team disagreements (different dynamic entirely)

## Negative examples
- "Help me find clients" → No. This is for deal-closing, not lead gen.
- "Write my Upwork proposal" → No. Use proposal-writing skill.
- "A client is unhappy with the work" → No. That's service recovery, not negotiation.

## Edge cases
- Upwork client asks for lower rate → YES. Price defense framework applies.
- Client wants to add scope without budget increase → YES. Scope protection.
- Revenue share structure (Alfred) → YES. Partnership term negotiation.
- Negotiating with yourself (pricing confidence) → Borderline but useful — the inner game section helps.

---

## Chris Voss's Core Principles

### 1. Tactical Empathy
Understand their perspective BEFORE pushing yours. Not fake empathy — genuine curiosity about their constraints.

**In practice:**
- "It sounds like budget is tight this quarter." (labeling)
- "How can we structure this so it works for both of us?" (calibrated question)
- "What would make you feel confident moving forward?" (their terms, not yours)

### 2. Go for "No"
Stop chasing "yes." People feel trapped by yes. When they say "no," they feel safe and in control — then they'll actually listen.

**In practice:**
- Instead of "Would you like to move forward?" → "Would it be a terrible idea to start with a pilot?"
- Instead of "Can we agree on $500?" → "Is $500 unreasonable for this scope?"
- After their "no": "What would you need to change to make this work?"

### 3. Get to "That's Right"
"That's right" = genuine alignment. "You're right" = they're dismissing you. Know the difference.

**How to trigger it:** Summarize their situation so accurately they say "that's right":
"So if I understand correctly — you need this done by March, your budget is around $300, and your main concern is that the last developer left the project half-done. That's a lot of risk to take on again."

When they say "that's right," you own the conversation.

### 4. Mirroring
Repeat the last 1-3 words they said. It feels like magic — they'll elaborate, reveal more information, and feel heard.

**Example:**
- Client: "We've been burned before by freelancers who disappear."
- You: "...who disappear?"
- Client: "Yeah, our last developer took the deposit and stopped responding after week 2."
- Now you know the REAL objection and can address it directly.

### 5. Labeling
Name their emotion or concern out loud. "It seems like..." / "It sounds like..." / "It feels like..."

**Example:**
- "It seems like you're worried about committing to a monthly retainer."
- "It sounds like the previous experience made you cautious about paying upfront."

Labeling defuses negative emotions and amplifies positive ones.

---

## The Ackerman Model (Price Negotiation)

When you MUST negotiate on price (not ideal — hold value first):

1. Set your target price
2. First offer: 65% of your target (if they're offering first, let them anchor)
3. Second offer: 85% of target
4. Third offer: 95% of target
5. Final offer: 100% of target + throw in a non-monetary perk

**Example (your target: $500):**
- They say: "Can you do it for $300?"
- You: "Based on the scope, I'd normally be at $700 for this. (anchor high) I could do $425 if we trim [specific thing]."
- They push back: "Still high."
- You: "$475, and I'll include documentation + 1 week of support."
- Final: "$500 flat, includes everything, and I'll start today."

**The non-round number trick:** $487 feels more calculated and credible than $500. Use precise numbers in final offers.

---

## Rate Defense Framework

When a client says "your rate is too high":

### Step 1: Don't React
Silence is power. Pause for 3 seconds. Let the discomfort sit. Most people fill silence with concessions — don't be that person.

### Step 2: Acknowledge
"I appreciate you being upfront about that." (builds trust)

### Step 3: Reframe Value
"Let me walk you through what this investment delivers: [specific outcomes from discovery]. For context, agencies charge $150-200/hr for this. My rate reflects [your specific edge]."

### Step 4: Offer Structure, Not Discount
- "Would it help to split into milestones? Pay $250 now, $250 on completion."
- "We could reduce scope to fit $X — I'd remove [specific item]. Which matters most to you?"
- "I can offer a 10% discount on a 3-month retainer." (trades discount for commitment)

### Step 5: Walk Away (If Needed)
"I want to make sure you get the right fit. If $X doesn't work for your budget, I totally understand. Would you like me to recommend someone in a different price range?"

Walking away with grace often brings them back at your price.

---

## Scope Creep Defense

When "just one more thing" keeps happening:

**Prevention (in proposal):**
- Explicit "What's NOT included" section
- "Additional requests billed at $X/hr or scoped separately"
- Milestone-based payments tied to specific deliverables

**In the moment:**
1. Acknowledge: "Great idea — I can see why that'd be valuable."
2. Scope it: "That would take approximately X hours to add."
3. Option: "Want me to include it in a Phase 2 scope, or add it to this project at $Y?"
4. Never: Just absorb it silently. Every "free" addition trains them to expect more.

---

## Revenue Share / Equity Negotiation

For deals like Alfred (equity/rev share):

**Protect yourself:**
- Define exactly what "revenue" means (gross? net? after expenses?)
- Set a minimum monthly guarantee if possible
- Time-box the agreement (12 months, then renegotiate)
- Define what happens if the client stops using the service
- Get it in writing — even a simple email agreement

**Fair structures:**
- 10-20% of revenue generated by your automation (directly attributable)
- $0 upfront + rev share (higher risk for you = higher % justified)
- Monthly retainer + smaller rev share (balanced risk)

---

## The Inner Game

The biggest negotiation is with yourself:

- **Don't apologize for your price.** "My rate is $49/hr" not "My rate is, um, $49... if that works?"
- **Silence is your weapon.** State your price and stop talking. The first person to speak after the number loses.
- **You're a peer, not a supplicant.** Discovery-first selling positions you as an expert diagnosing their problem, not an applicant hoping for work.
- **Walk-away power is real.** If you're willing to lose the deal, you negotiate from strength. If you're desperate, they smell it.
- **Raise your rate.** If you're winning 100% of proposals, you're too cheap. Aim for 30-50% win rate — that means your price is in the right zone.

---

## Key Principles
- Negotiation is not combat — it's collaborative problem-solving
- Tactical empathy > aggressive tactics (every time)
- "No" is the start of negotiation, not the end
- Never split the difference — find creative solutions instead of meeting in the middle
- Non-round numbers ($487 vs $500) signal precision and credibility
- If you win 100% of negotiations, you're leaving money on the table
