# Copywriting — Conversion Copy That Sells

Write landing pages, product descriptions, ads, and sales copy using proven direct-response frameworks.
Sources: Digitaloft (13 frameworks), CrazyEgg, NON.agency, DesignRush (direct response examples).
All outputs go to `workspace/artifacts/`.

## Use when
- Writing landing page copy (Gumroad, product pages, ClawHub listings)
- Crafting product descriptions that convert browsers to buyers
- Writing ad copy (social, search, display)
- Improving existing copy that isn't converting
- Writing Upwork profile descriptions or service listings
- Creating CTA buttons and microcopy
- Sales page sections (hero, features, testimonials, pricing)

## Don't use when
- Cold outreach emails (use cold-outreach skill — different format)
- Blog posts for SEO (different goal — traffic, not immediate conversion)
- Technical documentation (clarity > persuasion)
- Proposals (use proposal-writing skill)

## Negative examples
- "Write me a cold email" → No. Use cold-outreach skill.
- "Help me with my resume" → No. Different format entirely.
- "Write a technical README" → No. Documentation, not sales.

## Edge cases
- Upwork profile bio → YES. It's a mini sales page — you're selling yourself.
- ClawHub skill descriptions → YES. Descriptions should make people install.
- Email subject lines → YES. Subject lines are conversion copy (open rate = conversion).
- Discord channel descriptions → Borderline. Only if you need them to drive action.

---

## The 6 Core Frameworks

Pick the framework that matches your copy's goal:

### 1. PAS — Problem, Agitate, Solve
**Best for:** Landing pages, product pages, pain-point-driven products.

```
[PROBLEM] You're losing bookings every time your phone goes to voicemail.
[AGITATE] That's 3-5 clients a week — $300-500/month walking out the door while your hands are busy.
[SOLVE] Our SMS automation catches every missed call and books them automatically. One therapist went from 15 to 22 clients/week in 30 days.
```

**When to use:** When the audience KNOWS they have a problem. Agitation makes them feel the cost of inaction.

### 2. AIDA — Attention, Interest, Desire, Action
**Best for:** Ads, email subject lines, general sales pages.

```
[ATTENTION] What if your agent could earn money while you sleep?
[INTEREST] The Reef orchestrates local AI models to handle tasks 24/7 — no cloud API costs.
[DESIRE] Imagine checking your dashboard and seeing 50 tasks completed overnight, at $0 compute cost.
[ACTION] Get The Reef for $29 → [CTA button]
```

**When to use:** When you need to grab cold traffic and walk them through to action.

### 3. FAB — Features, Advantages, Benefits
**Best for:** Product descriptions, feature pages, comparison sections.

```
[FEATURE] Automated SMS auto-responder
[ADVANTAGE] Responds to missed calls in under 5 seconds — faster than any human
[BENEFIT] Never lose a booking to voicemail again. Clients feel heard even when you're busy.
```

**When to use:** When you need to translate features into reasons people should care. Most tech products describe features but forget benefits.

### 4. BAB — Before, After, Bridge
**Best for:** Transformation-focused copy, case studies, testimonials.

```
[BEFORE] You're manually checking voicemails between sessions, texting clients back hours late.
[AFTER] Your phone handles it all — instant replies, automatic booking, review requests sent after each session.
[BRIDGE] Our automation system connects your phone to your calendar. Setup takes 15 minutes.
```

### 5. The 4 Ps — Promise, Picture, Proof, Push
**Best for:** Long-form sales pages.

```
[PROMISE] Double your bookings without hiring a receptionist.
[PICTURE] Imagine finishing a session and seeing 3 new bookings confirmed — all handled while you worked.
[PROOF] "I went from 15 to 22 clients a week in my first month." — Alfred, Soothing Escape Massage
[PUSH] Start your free trial today. Cancel anytime. → [CTA]
```

### 6. Star-Story-Solution
**Best for:** About pages, brand narratives, personal selling.

```
[STAR] Meet Celeste — an AI agent that lives on a Mac mini and builds automation for small businesses.
[STORY] Built by a solo developer who was tired of seeing small business owners drown in admin work.
[SOLUTION] Now Celeste powers SMS automation, booking systems, and AI workflows — starting at $149/mo.
```

---

## Landing Page Structure

A high-converting landing page follows this order:

### 1. Hero Section
- **Headline:** One clear promise (10 words or fewer)
- **Subhead:** How you deliver on the promise (1-2 sentences)
- **CTA:** Primary action button
- **Visual:** Product screenshot, demo, or relevant image

**Formula:** "[Outcome] without [pain point]"
- "Automate Your Bookings Without Missing a Single Client"
- "Run Local AI Models Without Cloud API Bills"

### 2. Problem Section
Use PAS. Name their pain. Make it specific.

### 3. Solution Section
Use FAB. Show what you built and why it matters to THEM.

### 4. Social Proof
- Testimonials with specific results ("went from X to Y")
- Client logos (if B2B)
- Numbers ("500+ agents use this skill")
- Star ratings or review excerpts

### 5. How It Works
3 simple steps. Remove complexity.
```
Step 1: [Easy first action]
Step 2: [We do the work]
Step 3: [They get the result]
```

### 6. Pricing
Use pricing-psychology skill. Show value before price. Anchor high.

### 7. FAQ / Objection Handling
Address top 4-5 objections in Q&A format (see objection-handling skill).

### 8. Final CTA
Repeat the hero CTA. Add urgency if real.

---

## Copy Rules (Non-Negotiable)

1. **Write for scanners.** Most people skim. Use headlines, bullets, bold, and short paragraphs.
2. **One idea per sentence.** Complex sentences kill conversion.
3. **"You" > "We."** The copy is about THEM, not you. Count your "you"s vs "we"s.
4. **Specific > Vague.** "Save 5 hours/week" beats "save time." Numbers create belief.
5. **Benefits > Features.** Features tell. Benefits sell. Always translate.
6. **CTA = Action verb + Outcome.** "Get Started" < "Start Automating Today"
7. **Cut 30%.** First draft is always too long. Cut ruthlessly. Every word must earn its place.
8. **Read it out loud.** If you stumble, rewrite. Copy should flow like conversation.

---

## CTA Writing Guide

| Weak | Strong | Why |
|------|--------|-----|
| Submit | Get My Free Guide | Outcome-focused |
| Click Here | Start Automating Today | Action + benefit |
| Learn More | See How It Works | Specific curiosity |
| Sign Up | Join 500+ Agents | Social proof + action |
| Buy Now | Get The Reef — $29 | Clear price, clear product |
| Download | Grab Your Checklist | Casual, energetic |

---

## Platform-Specific Notes

**Gumroad listings:**
- Title = benefit-driven headline (not product name alone)
- First 2 lines visible in search — make them count
- Use bullet points for features/benefits
- Include "What's inside" section

**ClawHub skill descriptions:**
- Lead with what problem the skill solves
- "Use when / Don't use when" is visible to browsers — make it compelling
- Include a result: "Used by X agents" or "Built from Y sources"

**Upwork profile:**
- First 2 lines = hook (visible before "more")
- Lead with client outcomes, not your resume
- Specific numbers: "Built 50+ automations" > "experienced developer"

---

## Key Principles
- Copy is a conversation, not a lecture
- Every piece of copy has ONE job: get them to take the NEXT step
- The headline does 80% of the work — spend 50% of your time on it
- Specificity builds trust. Vagueness breeds skepticism.
- Test > opinion. When in doubt, A/B test.
