# Subreddit Reference

## Target Subreddits — Full List

| Subreddit | Size | Audience | QuantWheel OK? | AI Ban? | Notes |
|-----------|------|----------|---------------|---------|-------|
| r/thetagang | Large | Experienced option sellers | ❌ No | Soft | No self-promo at all. Education only. High quality bar. |
| r/options | Large | Mixed, active | ❌ No | **Hard** | Rule 1: no AI content, no rephrasing. Flag all drafts. |
| r/Optionswheel | Medium | Dedicated wheel traders | ❌ No | Soft | No promo. Keep posts under 500 words. CC posts → megathread only. |
| r/CoveredCalls | Medium | CC-focused | ⚠️ Check rules | No | Strike/DTE/rolling content performs well. Check rules before mention. |
| r/optionstrading | Medium | Broader options | ❌ No | Soft | No self-promo. Excessive AI text = low-effort removal. |
| r/CashSecuredPuts | Medium | CSP-focused | ⚠️ Check rules | No | Assignment management content is evergreen here. |
| r/fatFIRE | Large | High-NW, FIRE-focused | ✅ Natural | No | Sophisticated audience. "Boring but consistent" framing works. |
| r/OptionsMillionaire | Medium | Aspirational traders | ✅ Careful | No | Mix educational with outcome examples. |
| r/stocks | Very large | General investors | ⚠️ Off-topic risk | No | Options content welcome but keep accessible. |
| r/ExpiredOptions | Small | Option sellers | ⚠️ Check rules | No | Smaller, engaged community. |
| r/VegaGang | Small | Vol traders | ⚠️ Check rules | No | High IV discussion, technical audience. |
| r/PMTraders | Small | Portfolio margin | ⚠️ Check rules | No | Very sophisticated. Complex multi-leg audience. |
| r/Options_Beginners | Medium | New traders | ✅ Direct | No | Most permissive. Step-by-step content. QuantWheel as learning aid. |
| r/ActiveOptionTraders | Small | Active traders | ⚠️ Check rules | No | Timing and rolling content resonates. |
| r/OptionsExclusive | Small | Mixed | ⚠️ Test first | No | Less established. Test with one post before committing. |
| r/theta | Small | Theta sellers | ⚠️ Check rules | No | Smaller, engaged. |
| r/options_trading | Medium | Mixed | ❌ No links | No | No external website links allowed. |

## Hard Rules Quick Reference

**Never do these regardless of subreddit:**
- Post AI-generated content to r/options (Rule 1 — account ban risk)
- Mention QuantWheel in r/thetagang, r/Optionswheel, r/optionstrading, r/options_trading
- Post promotional content anywhere without checking that sub's rules first
- Cross-post the same content across multiple subs (spam rule)
- Post without reading lessons.md for the specific sub first

## Subreddit Research URLs

```
# New posts (use for research)
https://www.reddit.com/r/thetagang/new/.json
https://www.reddit.com/r/options/new/.json
https://www.reddit.com/r/Optionswheel/new/.json
https://www.reddit.com/r/CoveredCalls/new/.json
https://www.reddit.com/r/optionstrading/new/.json
https://www.reddit.com/r/OptionsMillionaire/new/.json
https://www.reddit.com/r/CashSecuredPuts/new/.json
https://www.reddit.com/r/stocks/new/.json
https://www.reddit.com/r/ExpiredOptions/new/.json
https://www.reddit.com/r/VegaGang/new/.json
https://www.reddit.com/r/PMTraders/new/.json
https://www.reddit.com/r/Options_Beginners/new/.json
https://www.reddit.com/r/ActiveOptionTraders/new/.json
https://www.reddit.com/r/OptionsExclusive/new/.json
https://www.reddit.com/r/theta/new/.json
https://www.reddit.com/r/options_trading/new/.json
https://www.reddit.com/r/fatFIRE/new/.json
```
